/*
 * Decompiled with CFR 0.152.
 */
package com.devsmart.ubjson;

import com.devsmart.ubjson.UBObject;
import com.devsmart.ubjson.UBValue;
import com.devsmart.ubjson.UBValueFactory;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class GsonUtil {
    public static UBValue toUBValue(JsonElement element) {
        if (element.isJsonNull()) {
            return UBValueFactory.createNull();
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return UBValueFactory.createBool((boolean)primitive.getAsBoolean());
            }
            if (primitive.isString()) {
                return UBValueFactory.createString((String)primitive.getAsString());
            }
            if (primitive.isNumber()) {
                return UBValueFactory.createNumber((Number)primitive.getAsNumber());
            }
        } else {
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                int size = array.size();
                UBValue[] ubArray = new UBValue[size];
                for (int i = 0; i < size; ++i) {
                    ubArray[i] = GsonUtil.toUBValue(array.get(i));
                }
                return UBValueFactory.createArray((UBValue[])ubArray);
            }
            if (element.isJsonObject()) {
                JsonObject jsonObject = element.getAsJsonObject();
                UBObject retval = UBValueFactory.createObject();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    retval.put((String)entry.getKey(), GsonUtil.toUBValue((JsonElement)entry.getValue()));
                }
                return retval;
            }
            throw new RuntimeException("unknown json element: " + element);
        }
        return null;
    }
}

