/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.util.objects.StoredIndexedBipartiteSet;

public class StoredIndexedBipartiteSetWithOffset
extends StoredIndexedBipartiteSet {
    private int offset;

    public StoredIndexedBipartiteSetWithOffset(IEnvironment environment, int[] values) {
        super(environment, values);
    }

    @Override
    public void buildList(IEnvironment environment, int[] values) {
        this.list = values;
        int maxElt = 0;
        int minElt = Integer.MAX_VALUE;
        for (int value : values) {
            if (value > maxElt) {
                maxElt = value;
            }
            if (value >= minElt) continue;
            minElt = value;
        }
        this.offset = minElt;
        this.position = new int[maxElt - this.offset + 1];
        for (int i = 0; i < values.length; ++i) {
            this.position[values[i] - this.offset] = i;
        }
        this.last = environment.makeInt(this.list.length - 1);
    }

    public boolean contain(int object) {
        return this.position[object - this.offset] <= this.last.get();
    }

    @Override
    public void remove(int object) {
        if (this.contain(object)) {
            int idxToRem = this.position[object - this.offset];
            if (idxToRem == this.last.get()) {
                this.last.add(-1);
            } else {
                int temp = this.list[this.last.get()];
                this.list[this.last.get()] = object;
                this.list[idxToRem] = temp;
                this.position[object - this.offset] = this.last.get();
                this.position[temp - this.offset] = idxToRem;
                this.last.add(-1);
            }
        }
    }

    public final int getOffset() {
        return this.offset;
    }
}

