/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.sliq;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.classifier.sliq.AttributeListEvent;
import dmLab.classifier.sliq.AttributeProxyEvent;
import java.util.ArrayList;

final class AttributeList {
    private boolean attrType;
    private int attrIndex;
    private AttributeListEvent[] events;
    private AttributeListEvent[] allEvents;
    private ArrayList<AttributeProxyEvent> proxies;
    private int proxiesNumber;
    private boolean splitStatus;

    public AttributeList(FArray trainArray, int attrIndex) {
        this.attrType = trainArray.attributes[attrIndex].type == 2 || trainArray.attributes[attrIndex].type == 0;
        int eventsNumber = ((Array)trainArray).rowsNumber();
        int nulls = 0;
        for (int i = 0; i < eventsNumber; ++i) {
            if (!Float.isNaN(trainArray.readValue(attrIndex, i))) continue;
            ++nulls;
        }
        this.attrIndex = attrIndex;
        this.events = new AttributeListEvent[eventsNumber - nulls];
        this.allEvents = new AttributeListEvent[eventsNumber];
        int j = 0;
        for (int i = 0; i < eventsNumber; ++i) {
            float tmp = trainArray.readValue(attrIndex, i);
            this.allEvents[i] = new AttributeListEvent();
            this.allEvents[i].attrValue = tmp;
            this.allEvents[i].classListIndex = i;
            if (Float.isNaN(tmp)) continue;
            this.events[j] = new AttributeListEvent();
            this.events[j].attrValue = tmp;
            this.events[j].classListIndex = i;
            ++j;
        }
        AttributeList attributeList = this;
        this.splitStatus = false;
        attributeList = this;
        attributeList.quickSort(0, attributeList.events.length - 1);
        attributeList = this;
        this.proxies = new ArrayList();
        int n = 0;
        float f = attributeList.events[0].attrValue;
        attributeList.proxies.add(new AttributeProxyEvent(f));
        attributeList.events[0].proxyIndex = 0;
        for (int i = 1; i < attributeList.events.length; ++i) {
            if (attributeList.events[i].attrValue != f) {
                f = attributeList.events[i].attrValue;
                attributeList.proxies.add(new AttributeProxyEvent(f));
            }
            attributeList.events[i].proxyIndex = ++n;
        }
        this.proxiesNumber = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("### attributeList ###\n");
        tmp.append("attrIndex: " + this.attrIndex + " objects:").append('\n');
        for (int i = 0; i < this.events.length; ++i) {
            if (this.events[i] == null) {
                tmp.append("null\n");
                continue;
            }
            tmp.append(this.events[i].toString()).append('\n');
        }
        return var1_1.toString();
    }

    public final void initSplitStatus() {
        this.splitStatus = false;
    }

    public final int getEventsNumber() {
        return this.events.length;
    }

    public final int getAllEventsNumber() {
        return this.allEvents.length;
    }

    public final boolean getAttrType() {
        return this.attrType;
    }

    public final int getAttrIndex() {
        return this.attrIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final int getAttrClassIndex(int eventIndex) {
        void var1_1;
        return this.events[var1_1].classListIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final int getAllAttrClassIndex(int eventIndex) {
        void var1_1;
        return this.allEvents[var1_1].classListIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final int getAttrProxyIndex(int eventIndex) {
        void var1_1;
        return this.events[var1_1].proxyIndex;
    }

    public final boolean getSplitStatus() {
        return this.splitStatus;
    }

    public final void setSplitStatus(boolean splitStatus) {
        this.splitStatus = true;
    }

    /*
     * WARNING - void declaration
     */
    private void quickSort(int l, int r) {
        while (true) {
            void var3_3;
            int i = l;
            int j = r;
            AttributeListEvent x = this.events[(l + r) / 2];
            while (true) {
                if (this.events[i].attrValue < x.attrValue) {
                    ++i;
                    continue;
                }
                while (this.events[j].attrValue > x.attrValue) {
                    --j;
                }
                if (i <= j) {
                    AttributeListEvent w = this.events[i];
                    this.events[i] = this.events[j];
                    this.events[j] = w;
                    ++i;
                    --j;
                }
                if (i > j) break;
            }
            if (l < j) {
                this.quickSort(l, j);
            }
            if (i >= r) break;
            l = var3_3;
        }
    }

    public final int getProxiesNumber() {
        return this.proxiesNumber;
    }

    /*
     * WARNING - void declaration
     */
    public final float getAttrProxyValue(int proxyIndex) {
        void var1_1;
        void var2_3 = var1_1;
        AttributeList attributeList = this;
        return attributeList.proxies.get((int)var2_3).attrValue;
    }
}

