/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.DateAdjustment;
import org.ohdsi.circe.cohortdefinition.DateRange;
import org.ohdsi.circe.cohortdefinition.NumericRange;
import org.ohdsi.circe.cohortdefinition.TextFilter;
import org.ohdsi.circe.helper.ResourceHelper;
import org.ohdsi.circe.vocabulary.Concept;

public abstract class BuilderUtils {
    private static final String CODESET_JOIN_TEMPLATE = "JOIN #Codesets %s on (%s = %s.concept_id and %s.codeset_id = %d)";
    private static final String DATE_ADJUSTMENT_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/dateAdjustment.sql");
    private static final String STANARD_ALIAS = "cs";
    private static final String NON_STANARD_ALIAS = "cns";

    public static String getDateAdjustmentExpression(DateAdjustment dateAdjustment, String startColumn, String endColumn) {
        String expression = StringUtils.replace((String)DATE_ADJUSTMENT_TEMPLATE, (String)"@startOffset", (String)Integer.toString(dateAdjustment.startOffset));
        expression = StringUtils.replace((String)expression, (String)"@startColumn", (String)startColumn);
        expression = StringUtils.replace((String)expression, (String)"@endOffset", (String)Integer.toString(dateAdjustment.endOffset));
        expression = StringUtils.replace((String)expression, (String)"@endColumn", (String)endColumn);
        return expression;
    }

    public static String getCodesetJoinExpression(Integer standardCodesetId, String standardConceptColumn, Integer sourceCodesetId, String sourceConceptColumn) {
        String joinExpression = "";
        ArrayList<String> codesetClauses = new ArrayList<String>();
        if (standardCodesetId != null) {
            codesetClauses.add(String.format(CODESET_JOIN_TEMPLATE, STANARD_ALIAS, standardConceptColumn, STANARD_ALIAS, STANARD_ALIAS, standardCodesetId));
        }
        if (sourceCodesetId != null) {
            codesetClauses.add(String.format(CODESET_JOIN_TEMPLATE, NON_STANARD_ALIAS, sourceConceptColumn, NON_STANARD_ALIAS, NON_STANARD_ALIAS, sourceCodesetId));
        }
        if (codesetClauses.size() > 0) {
            joinExpression = StringUtils.join(codesetClauses, (String)"\n");
        }
        return joinExpression;
    }

    public static String getOperator(String op) {
        switch (op) {
            case "lt": {
                return "<";
            }
            case "lte": {
                return "<=";
            }
            case "eq": {
                return "=";
            }
            case "!eq": {
                return "<>";
            }
            case "gt": {
                return ">";
            }
            case "gte": {
                return ">=";
            }
        }
        throw new RuntimeException("Unknown operator type: " + op);
    }

    public static String getOperator(NumericRange range) {
        return BuilderUtils.getOperator(range.op);
    }

    public static String getOperator(DateRange range) {
        return BuilderUtils.getOperator(range.op);
    }

    public static String dateStringToSql(String date) {
        String[] dateParts = StringUtils.split((String)date, (char)'-');
        return String.format("DATEFROMPARTS(%s, %s, %s)", Integer.valueOf(dateParts[0]), Integer.valueOf(dateParts[1]), Integer.valueOf(dateParts[2]));
    }

    public static String buildDateRangeClause(String sqlExpression, DateRange range) {
        String clause = range.op.endsWith("bt") ? String.format("%s(%s >= %s and %s <= %s)", range.op.startsWith("!") ? "not " : "", sqlExpression, BuilderUtils.dateStringToSql(range.value), sqlExpression, BuilderUtils.dateStringToSql(range.extent)) : String.format("%s %s %s", sqlExpression, BuilderUtils.getOperator(range), BuilderUtils.dateStringToSql(range.value));
        return clause;
    }

    public static String buildNumericRangeClause(String sqlExpression, NumericRange range, String format) {
        String clause = range.op.endsWith("bt") ? String.format("%s(%s >= %s and %s <= %s)", range.op.startsWith("!") ? "not " : "", sqlExpression, BuilderUtils.formatDouble(range.value.doubleValue(), format), sqlExpression, BuilderUtils.formatDouble(range.extent.doubleValue(), format)) : String.format("%s %s %s", sqlExpression, BuilderUtils.getOperator(range), BuilderUtils.formatDouble(range.value.doubleValue(), format));
        return clause;
    }

    public static String buildNumericRangeClause(String sqlExpression, NumericRange range) {
        String clause = range.op.endsWith("bt") ? String.format("%s(%s >= %d and %s <= %d)", range.op.startsWith("!") ? "not " : "", sqlExpression, range.value.intValue(), sqlExpression, range.extent.intValue()) : String.format("%s %s %d", sqlExpression, BuilderUtils.getOperator(range), range.value.intValue());
        return clause;
    }

    public static ArrayList<Long> getConceptIdsFromConcepts(Concept[] concepts) {
        ArrayList<Long> conceptIdList = new ArrayList<Long>();
        for (Concept concept : concepts) {
            conceptIdList.add(concept.conceptId);
        }
        return conceptIdList;
    }

    public static String buildTextFilterClause(String sqlExpression, TextFilter filter) {
        String negation = filter.op.startsWith("!") ? "not" : "";
        String prefix = filter.op.endsWith("endsWith") || filter.op.endsWith("contains") ? "%" : "";
        String postfix = filter.op.endsWith("startsWith") || filter.op.endsWith("contains") ? "%" : "";
        String value = BuilderUtils.escapeSqlParam(filter.text);
        return String.format("%s %s like '%s%s%s'", sqlExpression, negation, prefix, value, postfix);
    }

    private static String escapeSqlParam(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        return value.replaceAll("\\\\*\\'", "''");
    }

    private static String formatDouble(double d, String format) {
        String formatString = "%" + format;
        return String.format(Locale.US, formatString, d);
    }

    public static <T> String splitInClause(String column, List<T> values, int groupSize) {
        ArrayList<List<T>> groups = new ArrayList<List<T>>();
        for (int i = 0; i < values.size(); i += groupSize) {
            int endIndex = Math.min(i + groupSize, values.size());
            groups.add(values.subList(i, endIndex));
        }
        List ins = groups.stream().map(group -> String.format("%s in (%s)", column, StringUtils.join((Iterable)group, (String)","))).collect(Collectors.toList());
        return String.format("(%s)", StringUtils.join(ins, (String)" or "));
    }
}

