/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.SVarSet;
import org.rosuda.ibase.toolkit.QueryPopup;
import org.rosuda.ibase.toolkit.SWINGGraphicsDevice;
import org.rosuda.util.Global;
import org.rosuda.util.Tools;

public class SwingQueryPopup
implements MouseListener,
QueryPopup {
    JToolTip win;
    Window owner;
    SVarSet vs;
    SWINGGraphicsDevice grdev;

    public SwingQueryPopup(SWINGGraphicsDevice sWINGGraphicsDevice, Window window, SVarSet sVarSet, String string) {
        this(sWINGGraphicsDevice, window, sVarSet, string, -1, -1);
    }

    public SwingQueryPopup(SWINGGraphicsDevice sWINGGraphicsDevice, Window window, SVarSet sVarSet, String string, int n, int n2) {
        this.grdev = sWINGGraphicsDevice;
        this.vs = sVarSet;
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setReshowDelay(0);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(true);
    }

    public void show() {
        if (Global.DEBUG > 0) {
            System.out.println("SwingQueryPopup.show");
        }
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    public void hide() {
        if (Global.DEBUG > 0) {
            System.out.println("SwingQueryPopup.hide");
        }
        ToolTipManager.sharedInstance().setEnabled(false);
    }

    public void setContent(String string) {
        this.setContent(string, -1);
    }

    public void setContent(String string, int n) {
        String string2 = string;
        if (this.vs != null && n >= 0) {
            string2 = string2 + "\n";
            for (int i = 0; i < this.vs.count(); ++i) {
                if (this.vs.at(i) == null || !this.vs.at(i).isSelected()) continue;
                string2 = string2 + this.vs.at(i).getName() + ": " + this.vs.at(i).atS(n) + "\n";
            }
        }
        this.setContentString(string2);
    }

    public void setContent(String string, int[] nArray) {
        String string2 = string;
        if (this.vs != null && nArray != null && nArray.length > 0) {
            string2 = string2 + "\n";
            boolean bl = true;
            for (int i = 0; i < this.vs.count(); ++i) {
                int n;
                if (this.vs.at(i) == null || !this.vs.at(i).isSelected()) continue;
                if (bl) {
                    bl = false;
                    string2 = string2 + " ";
                }
                string2 = string2 + "\n";
                if (!this.vs.at(i).isNum()) continue;
                double d = 0.0;
                double d2 = 0.0;
                for (n = 0; n < nArray.length; ++n) {
                    if (this.vs.at(i).at(nArray[n]) == null) continue;
                    d += this.vs.at(i).atD(nArray[n]);
                    d2 += 1.0;
                }
                if (!(d2 > 0.0)) continue;
                double d3 = d / d2;
                double d4 = 0.0;
                for (n = 0; n < nArray.length; ++n) {
                    if (this.vs.at(i).at(nArray[n]) == null) continue;
                    double d5 = this.vs.at(i).atD(nArray[n]) - d3;
                    d4 += d5 * d5;
                }
                string2 = string2 + this.vs.at(i).getName() + ": mean=" + Tools.getDisplayableValue(d / d2) + " sd=" + Tools.getDisplayableValue(Math.sqrt(d4 / d2)) + "\n";
            }
        }
        this.setContentString(string2);
    }

    void setContentString(String string) {
        String string2 = "<html>";
        string2 = string2 + "<BODY BGCOLOR=\"rgb(" + Math.abs(Common.popupColor.getRed()) + "," + Math.abs(Common.popupColor.getGreen()) + "," + Math.abs(Common.popupColor.getBlue()) + ")\">";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreElements()) {
            string2 = string2 + stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreElements()) continue;
            string2 = string2 + "<br>";
        }
        string2 = string2 + "</body></html>";
        this.grdev.setToolTipText(string2);
    }

    public void setLocation(int n, int n2) {
        this.hide();
        this.show();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.hide();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Component getQueryComponent() {
        return this.win;
    }
}

