/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.integer.extension;

import choco.kernel.common.util.objects.OpenBitSet;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.ConsistencyRelation;
import choco.kernel.solver.constraints.integer.extension.ExtensionalBinRelation;
import choco.kernel.solver.variables.integer.IBitSetIntDomain;

public class CouplesBitSetTable
extends ConsistencyRelation
implements BinRelation,
ExtensionalBinRelation {
    protected OpenBitSet[][] table;
    protected int[] offsets;
    protected int[] ns;

    public CouplesBitSetTable() {
    }

    public CouplesBitSetTable(boolean feas, int offset1, int offset2, int n1, int n2) {
        int i;
        this.offsets = new int[]{offset1, offset2};
        this.table = new OpenBitSet[2][];
        this.table[0] = new OpenBitSet[n1];
        this.ns = new int[]{n1, n2};
        for (i = 0; i < n1; ++i) {
            this.table[0][i] = new OpenBitSet(n2);
            if (feas) continue;
            this.table[0][i].set(0, n2);
        }
        this.table[1] = new OpenBitSet[n2];
        for (i = 0; i < n2; ++i) {
            this.table[1][i] = new OpenBitSet(n1);
            if (feas) continue;
            this.table[1][i].set(0, n1);
        }
        this.feasible = feas;
    }

    @Override
    public ConsistencyRelation getOpposite() {
        CouplesBitSetTable t = new CouplesBitSetTable();
        t.feasible = !this.feasible;
        t.table = new OpenBitSet[2][];
        this.table[0] = new OpenBitSet[this.ns[0]];
        this.table[1] = new OpenBitSet[this.ns[1]];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.table[i].length; ++j) {
                t.table[i][j] = (OpenBitSet)this.table[i][j].clone();
                t.table[i][j].flip(0, this.ns[i]);
            }
        }
        t.ns = this.ns;
        t.offsets = this.offsets;
        return t;
    }

    @Override
    public void setCouple(int x, int y) {
        if (this.feasible) {
            this.table[0][x - this.offsets[0]].set(y - this.offsets[1]);
            this.table[1][y - this.offsets[1]].set(x - this.offsets[0]);
        } else {
            this.table[0][x - this.offsets[0]].clear(y - this.offsets[1]);
            this.table[1][y - this.offsets[1]].clear(x - this.offsets[0]);
        }
    }

    public void setCoupleWithoutOffset(int x, int y) {
        this.table[0][x].set(y);
        this.table[1][y].set(x);
    }

    @Override
    public boolean isConsistent(int x, int y) {
        return this.table[0][x - this.offsets[0]].get(y - this.offsets[1]);
    }

    @Override
    public boolean checkCouple(int x, int y) {
        return this.table[0][x - this.offsets[0]].get(y - this.offsets[1]);
    }

    public OpenBitSet getSupport(int var, int val) {
        assert (var == 0 || var == 1);
        return this.table[var][val - this.offsets[var]];
    }

    public boolean checkValue(int var, int val, IBitSetIntDomain v) {
        int i = v.getContent().nextSetBit(0);
        while (i >= 0) {
            if (this.table[var][val - this.offsets[var]].get(i)) {
                return true;
            }
            i = v.getContent().nextSetBit(i + 1);
        }
        return false;
    }
}

