/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule;

import eu.kliegr.ac1.performance.StopWatches;
import eu.kliegr.ac1.rule.PruneType;
import eu.kliegr.ac1.rule.Rule;
import eu.kliegr.ac1.rule.extend.ExtendRule;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class PruneRules {
    private static final Logger LOGGER = Logger.getLogger(PruneRules.class.getName());
    private List<ExtendRule> rules;
    private Comparator ruleComparator;
    private PruneType type;

    public PruneRules(ArrayList<Rule> rules, Comparator ruleComparator, PruneType type) {
        this.type = type;
        this.ruleComparator = ruleComparator;
        this.rules = rules.stream().map(rule -> new ExtendRule((Rule)rule)).collect(Collectors.toCollection(() -> Collections.synchronizedList(new ArrayList())));
    }

    public List<ExtendRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public void sortRules() {
        this.rules.sort(this.ruleComparator);
    }

    public void pruneRules() {
        LOGGER.info("STARTED Pruning");
        Iterator<ExtendRule> it = this.rules.iterator();
        while (it.hasNext()) {
            ExtendRule rule = it.next();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "#Rule {0}", rule.toString());
            }
            if (this.type == PruneType.antecedentOnly) {
                throw new UnsupportedOperationException("Antecedent only pruning type no longer supported");
            }
            if (rule.getAntecedentLength() == 0) {
                LOGGER.info("Skipping default rule");
                continue;
            }
            int supportingTransactions = rule.removeTransactionsCoveredByAntecedent(false);
            if (supportingTransactions == 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("0 transactions, REMOVED");
                }
                it.remove();
                continue;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.log(Level.FINE, "{0} transactions, RULE {1} KEPT", new Object[]{supportingTransactions, rule.getRID()});
        }
        LOGGER.info("FINISHED Removing rules with zero coverage");
    }

    public void saveSummary(int originalRulecount, String path, StopWatches watches) throws FileNotFoundException, IOException {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(path));
        ((OutputStream)output).write(("Number of rules before pruning:" + originalRulecount + "\n").getBytes());
        ((OutputStream)output).write(("Number of rules after pruning:" + this.rules.size() + "\n").getBytes());
        ((OutputStream)output).write(("Pruning type:" + this.type.name()).getBytes());
        ((OutputStream)output).write(watches.toString().getBytes());
        ((OutputStream)output).flush();
        ((OutputStream)output).close();
    }
}

