/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.channeling;

import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropClauseChanneling
extends Propagator<IntVar> {
    private final IntVar iv;
    private final boolean bounded;
    private final IIntDeltaMonitor dm;
    private final BoolVar[] eqs;
    private final BoolVar[] lqs;
    private final IStateInt LB;
    private final IStateInt UB;
    private final int OFFSET;
    private final int LENGTH;

    public PropClauseChanneling(IntVar iv, BoolVar[] eb, BoolVar[] lb) {
        super((Variable[])ArrayUtils.append(new IntVar[][]{{iv}, eb, lb}), (Priority)PropagatorPriority.LINEAR, true);
        this.iv = iv;
        this.bounded = !iv.hasEnumeratedDomain();
        this.eqs = eb;
        this.lqs = lb;
        this.OFFSET = iv.getLB();
        this.LENGTH = iv.getUB() - iv.getLB() + 1;
        this.LB = this.model.getEnvironment().makeInt();
        this.UB = this.model.getEnvironment().makeInt(this.LENGTH);
        IIntDeltaMonitor iIntDeltaMonitor = this.dm = iv.hasEnumeratedDomain() ? iv.monitorDelta(this) : IIntDeltaMonitor.Default.NONE;
        if (eb.length != this.LENGTH || lb.length != this.LENGTH) {
            throw new SolverException("BoolVar[] wrong dimension");
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if (this.iv.isInstantiated()) {
            int value = this.iv.getValue() - this.OFFSET;
            this.eqs[value].instantiateTo(1, (ICause)this);
            this.lqs[value].instantiateTo(1, (ICause)this);
        }
        int lb = this.iv.getLB() - this.OFFSET;
        int ub = this.iv.getUB() - this.OFFSET;
        for (i = 0; i < lb; ++i) {
            this.eqs[i].instantiateTo(0, (ICause)this);
            this.lqs[i].instantiateTo(0, (ICause)this);
        }
        for (i = ub + 1; i < this.LENGTH; ++i) {
            this.eqs[i].instantiateTo(0, (ICause)this);
            this.lqs[i].instantiateTo(1, (ICause)this);
        }
        while (lb < this.LENGTH && this.eqs[lb].isInstantiated()) {
            if (this.eqs[lb].isInstantiatedTo(0)) {
                this.iv.removeValue(lb + this.OFFSET, (ICause)this);
            } else {
                this.iv.instantiateTo(lb + this.OFFSET, (ICause)this);
            }
            ++lb;
        }
        while (ub > -1 && this.eqs[ub].isInstantiated()) {
            if (this.eqs[ub].isInstantiatedTo(0)) {
                this.iv.removeValue(ub + this.OFFSET, (ICause)this);
            } else {
                this.iv.instantiateTo(ub + this.OFFSET, (ICause)this);
            }
            --ub;
        }
        if (!this.bounded) {
            for (i = lb + 1; i < ub; ++i) {
                if (!this.iv.contains(i + this.OFFSET)) {
                    this.eqs[i].instantiateTo(0, (ICause)this);
                    continue;
                }
                if (!this.eqs[i].isInstantiated()) continue;
                if (this.eqs[i].isInstantiatedTo(0)) {
                    this.iv.removeValue(i + this.OFFSET, (ICause)this);
                    continue;
                }
                this.iv.instantiateTo(i + this.OFFSET, (ICause)this);
            }
        }
        while (lb < this.LENGTH && !this.iv.contains(lb + this.OFFSET)) {
            this.lqs[lb++].instantiateTo(0, (ICause)this);
        }
        while (ub > -1 && !this.iv.contains(ub + this.OFFSET)) {
            this.lqs[ub--].instantiateTo(1, (ICause)this);
        }
        if (ub > -1) {
            this.lqs[ub].instantiateTo(1, (ICause)this);
        }
        this.LB.set(lb);
        this.UB.set(ub);
        this.dm.startMonitoring();
    }

    @Override
    public void propagate(int vidx, int mask) throws ContradictionException {
        if (vidx == 0) {
            if (IntEventType.isInstantiate(mask)) {
                this._inst(this.iv.getValue() - this.OFFSET);
            } else {
                int lb = this.LB.get();
                int ub = this.UB.get();
                if (IntEventType.isInclow(mask)) {
                    this._ulb(this.iv.getLB() - this.OFFSET, lb);
                }
                if (IntEventType.isDecupp(mask)) {
                    this._uub(this.iv.getUB() - this.OFFSET, ub);
                }
                this.dm.forEachRemVal(value -> {
                    if ((value -= this.OFFSET) > lb && value < ub) {
                        this.eqs[value].instantiateTo(0, (ICause)this);
                    }
                });
            }
        } else {
            int act = 0;
            if (--vidx < this.LENGTH) {
                if (this.eqs[vidx].getValue() != 1) {
                    if (vidx == this.LB.get()) {
                        act = 1;
                    } else if (vidx == this.UB.get()) {
                        act = 2;
                        --vidx;
                    } else {
                        act = 3;
                    }
                }
            } else {
                act = this.lqs[vidx -= this.LENGTH].getValue() == 1 ? 2 : 1;
            }
            switch (act) {
                case 0: {
                    this.iv.instantiateTo(vidx + this.OFFSET, (ICause)this);
                    this._inst(vidx);
                    break;
                }
                case 1: {
                    this.iv.updateLowerBound(vidx + this.OFFSET + 1, (ICause)this);
                    if (this.iv.isInstantiated()) {
                        this._inst(this.iv.getValue() - this.OFFSET);
                        break;
                    }
                    this._ulb(this.iv.getLB() - this.OFFSET, this.LB.get());
                    break;
                }
                case 2: {
                    this.iv.updateUpperBound(vidx + this.OFFSET, (ICause)this);
                    if (this.iv.isInstantiated()) {
                        this._inst(this.iv.getValue() - this.OFFSET);
                        break;
                    }
                    this._uub(this.iv.getUB() - this.OFFSET, this.UB.get());
                    break;
                }
                case 3: {
                    this.iv.removeValue(vidx + this.OFFSET, (ICause)this);
                    if (this.iv.isInstantiated()) {
                        this._inst(this.iv.getValue() - this.OFFSET);
                        break;
                    }
                    this._rem(vidx);
                }
            }
        }
    }

    private void _inst(int value) throws ContradictionException {
        this._ulb(value, this.LB.get());
        this.eqs[value].instantiateTo(1, (ICause)this);
        this.lqs[value].instantiateTo(1, (ICause)this);
        this._uub(value, this.UB.get());
    }

    private void _ulb(int nlb, int olb) throws ContradictionException {
        for (int i = olb; i < nlb; ++i) {
            this.eqs[i].instantiateTo(0, (ICause)this);
            this.lqs[i].instantiateTo(0, (ICause)this);
        }
        this.LB.set(nlb);
        if (this.eqs[nlb].isInstantiatedTo(0)) {
            ++nlb;
            while (nlb < this.LENGTH && this.eqs[nlb].isInstantiatedTo(0)) {
                ++nlb;
            }
            this.iv.updateLowerBound(nlb + this.OFFSET, (ICause)this);
            if (this.iv.isInstantiated()) {
                this._inst(this.iv.getValue() - this.OFFSET);
            } else {
                this._ulb(this.iv.getLB() - this.OFFSET, this.LB.get());
            }
        }
    }

    private void _uub(int nub, int oub) throws ContradictionException {
        for (int i = oub; i > nub; --i) {
            this.eqs[i].instantiateTo(0, (ICause)this);
            this.lqs[i].instantiateTo(1, (ICause)this);
        }
        this.lqs[nub].instantiateTo(1, (ICause)this);
        this.UB.set(nub);
        if (this.eqs[nub].isInstantiatedTo(0)) {
            --nub;
            while (nub > -1 && this.eqs[nub].isInstantiatedTo(0)) {
                --nub;
            }
            this.iv.updateUpperBound(nub + this.OFFSET, (ICause)this);
            if (this.iv.isInstantiated()) {
                this._inst(this.iv.getValue() - this.OFFSET);
            } else {
                this._uub(this.iv.getUB() - this.OFFSET, this.UB.get());
            }
        }
    }

    private void _rem(int value) throws ContradictionException {
        this.eqs[value].instantiateTo(0, (ICause)this);
        if (this.iv.isInstantiated()) {
            this._inst(this.iv.getValue());
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int k;
            int value = this.iv.getValue() - this.OFFSET;
            for (k = 0; k < value; ++k) {
                if (!this.eqs[k].isInstantiatedTo(1) && !this.lqs[k].isInstantiatedTo(1)) continue;
                return ESat.FALSE;
            }
            if (this.eqs[value].isInstantiatedTo(0) || this.lqs[value].isInstantiatedTo(0)) {
                return ESat.FALSE;
            }
            for (k = value + 1; k < this.LENGTH; ++k) {
                if (!this.eqs[k].isInstantiatedTo(1) && !this.lqs[k].isInstantiatedTo(0)) continue;
                return ESat.FALSE;
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

