# surveyvoi 1.1.1

- CRAN release.
- Update `configure.ac` and `configure` files to remove bashisms.
- Update package manual entry and vignette with citation information.
- Update package manual entry with package website, issue tracker, and code
  repository.
- Update tests for `env_div_survey_scheme()` and `geo_cov_survey_scheme()`
  to prevent tests from sporadically failing due to multiple optimal solutions.

# surveyvoi 1.1.0.2

- Fix bug in `fit_xgb_occupancy_models()` that caused an error during model
  fitting due to failed predictions.
- Fix package citation.

# surveyvoi 1.1.0.1

- Fix bug in `greedy_heuristic_algorithm()` function so that it returns a
  solution if it is not possible to select enough planning units to meet the
  target for any species. Instead of throwing an error, it will now throw a
  warning and return a solution containing the cheapest set of planning units
  within the budget and locked out constraints. Note that this solution
  will have an objective value of zero, because it has zero probability of
  meeting any of the species' targets.

# surveyvoi 1.1.0.0

- New `greedy_heuristic_algorithm()` function that can be used to generate
  reserve selection prioritizations. This function provides access to the
  internal algorithm used for the reserve selection component of the
  value of information calculations.
- Update internal greedy reserve selection algorithm to find better quality
  prioritizations. This impacts `approx_near_optimal_survey_scheme()`,
  `approx_optimal_survey_scheme()`, `optimal_survey_scheme()`,
  `approx_evdsi()`, `evdsi()`, and `evdci()`.
- Update `sim_sites` and `sim_features` example datasets.
- Fix bug in `approx_near_optimal_survey_scheme()`,
  `approx_optimal_survey_scheme()`, `optimal_survey_scheme()`,
  `approx_evdsi()`, `evdsi()`, and `evdci()` where all species were incorrectly
  assigned the same target as the first species during calculations.

# surveyvoi 1.0.6

- Fix installation for Windows on arm64 (#50).
- Fix aliasing for package overview help file (#49).
- Remove CXX specification in Makevars to avoid NOTEs in package checks.

# surveyvoi 1.0.5.1

- Update citation.

# surveyvoi 1.0.5

- CRAN release.
- Skip tests on Fedora systems because unable to reproduce error on CRAN.
- Fix compiler warning thrown during installation.
- Fix compatibility issues with upcoming _Matrix_ package (version >= 1.4-2) .
- Fix issues unloading package properly.
- Update citation information in README.

# surveyvoi 1.0.4

- CRAN release.

# surveyvoi 1.0.3.12

- Update CRAN comments document and remove pkg-config from system requirements.
- Fix compiler warning thrown during installation.

# surveyvoi 1.0.3.11

- Update `simulate_site_data()` function to remove _RandomFields_ package
  as a dependency.

# surveyvoi 1.0.3.10

- Fix CRAN note about _utils_ package dependency.
- Skip unit tests that require _RandomFields_ package on Windows to avoid
  spurious failures.

# surveyvoi 1.0.3.9

- Update documentation for new code repository location.
- Add remote for _RandomFields_ package to facilitate installation.

# surveyvoi 1.0.3.8

- Standardize spelling (en-US).

# surveyvoi 1.0.3.7

- Tweak package documentation.
- The _RandomFields_ package is now an optional dependency.

# surveyvoi 1.0.3.6

- Update README with system requirements for _PoissonBinomial_ package (#42).

# surveyvoi 1.0.3.5

- Autoconf is used for installation on Linux and macOS operating systems.

# surveyvoi 1.0.3.4

- Update `prior_probability_matrix()` to compute prior probabilities when
  no existing survey data are available.

# surveyvoi 1.0.3.3

- Fix issue with `fit_xgb_occupancy_models()` using more than specified number
  of threads for parallel processing.
- Ensure that PSOCK and FORK clusters used for parallel processing are
  terminated correctly, even when processing is interrupted.

# surveyvoi 1.0.3.2

- Fix compatibility issues with updated _xgboost_ package (version 1.5.0).
- Fix parallel processing tests given updates to the _testthat_ package
  (version 3.1.2).
- Fix tests for environmental and geographic survey schemes given updates to
  the _gurobi_ package (version 9.5.0).

# surveyvoi 1.0.3.1

- GMP dependencies on Windows systems are now handled using RWinLib
  (see https://github.com/rwinlib/gmp).
- Package configuration now reports compilation variables
  (i.e. PKG_CPPFLAGS and PKG_LIBS variables).
- The Free Software Foundation is no longer listed as a contributor and
  copyright holder because GMP source files are no longer distributed
  with the package (because GMP dependencies are obtained via RWinLib).
- Configuration variables can now (optionally) be used to specify location of
  GMP and MPFR dependencies for package installation (i.e. GMP_INCLUDE_DIR,
  GMP_LIB_DIR, MPFR_INCLUDE_DIR and MPFR_LIB_DIR). Although the package
  configuration routine attempts to deduce these variables automatically,
  the variables can be used if installation with default settings fails.
  For example, the variables can be set using the following system command:
  ```
  R CMD INSTALL --configure-vars='GMP_INCLUDE_DIR=... GMP_LIB_DIR=... MPFR_INCLUDE_DIR=... MPFR_LIB_DIR=...'
  ```

# surveyvoi 1.0.3

- CRAN release.
- Fix issue with missing gmpxx file.
- Remove unused dependencies.

# surveyvoi 1.0.2

- CRAN release.
- Update CRAN comments.
- Update examples.
- Improve documentation for functions that depend on external software.

# surveyvoi 1.0.1

-  Fix typos in documentation (#38).
-  Add details for tuning xgboost models to documentation (#39).

# surveyvoi 1.0.0

- Refactor for official release.
- Add support for generating surveys with the _Rsymphony_ package.

# surveyvoi 0.0.76

- All functions appear to work.

# surveyvoi 0.0.1

- Initial commit.
