## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

library(zeallot)

## -----------------------------------------------------------------------------
c(lat, lng) %<-% list(38.061944, -122.643889)

## -----------------------------------------------------------------------------
lat
lng

## -----------------------------------------------------------------------------
c(lat, lng) %<-% c(38.061944, -122.643889)
lat
lng

## -----------------------------------------------------------------------------
c(min_wt, q1_wt, med_wt, mean_wt, q3_wt, max_wt) %<-% summary(mtcars$wt)
min_wt
q1_wt
med_wt
mean_wt
q3_wt
max_wt

## ----error=TRUE---------------------------------------------------------------
try({
c(stg1, stg2, stg3) %<-% list("Moe", "Donald")
})

## ----error=TRUE---------------------------------------------------------------
try({
c(stg1, stg2, stg3) %<-% list("Moe", "Larry", "Curley", "Donald")
})

## -----------------------------------------------------------------------------
#
# A function which returns a list of 2 numeric values.
# 
coords_list <- function() {
  list(38.061944, -122.643889)
}

c(lat, lng) %<-% coords_list()
lat
lng

## -----------------------------------------------------------------------------
#
# Convert cartesian coordinates to polar
#
to_polar = function(x, y) {
  c(sqrt(x^2 + y^2), atan(y / x))
}

c(radius, angle) %<-% to_polar(12, 5)
radius
angle

## -----------------------------------------------------------------------------
c(inter, slope) %<-% coef(lm(mpg ~ cyl, data = mtcars))
inter
slope

## ----eval = require("purrr")--------------------------------------------------
safe_log <- purrr::safely(log)

## ----eval = require("purrr")--------------------------------------------------
pair <- safe_log(10)
pair$result
pair$error

## ----eval = require("purrr")--------------------------------------------------
pair <- safe_log("donald")
pair$result
pair$error

## ----eval = require("purrr")--------------------------------------------------
c(res, err) %<-% safe_log(10)
res
err

## -----------------------------------------------------------------------------
c(mpg=, cyl=, dist=, hp=) %<-% mtcars

cyl

## -----------------------------------------------------------------------------
c(gear3, gear4, gear5) %<-% split(mtcars, ~ gear)

head(gear3)

head(gear4)

gear5

## -----------------------------------------------------------------------------
lm_mpg_cyl <- lm(mpg ~ cyl, data = mtcars)

c(lmc_call, lmc_terms, lmc_residuals, ..rest) %<-% summary(lm_mpg_cyl)

lmc_call

lmc_terms

head(lmc_residuals)

## -----------------------------------------------------------------------------
str(rest)

## -----------------------------------------------------------------------------
c(..skip, e, f) %<-% list(1, 2, 3, 4, 5)
skip
e
f

## -----------------------------------------------------------------------------
c(begin, ..middle, end) %<-% list(1, 2, 3, 4, 5)
begin
middle
end

## -----------------------------------------------------------------------------
c(x, ., z) %<-% list(1, 2, 3)
x
z

## -----------------------------------------------------------------------------
c(begin, .., end) %<-% list("hello", "blah", list("blah"), "blah", "world!")
begin
end

## -----------------------------------------------------------------------------
c(begin, ., ..middle, end) %<-% list(1, 2, 3, 4, 5)
begin
middle
end

## -----------------------------------------------------------------------------
nums <- c(1, 2)
c(x, y) %<-% tail(nums, 2)
x
y

## ----error = TRUE-------------------------------------------------------------
try({
c(x, y, z) %<-% tail(nums, 3)
})

## -----------------------------------------------------------------------------
c(x, y, z = NULL) %<-% tail(nums, 3)
x
y
z

## -----------------------------------------------------------------------------
c(first, last) %<-% c("Ai", "Genly")
first
last

c(first, last) %<-% c(last, first)
first
last

## -----------------------------------------------------------------------------
cat <- "meow"
dog <- "bark"

c(cat, dog, fish) %<-% c(dog, cat, dog)
cat
dog
fish

