/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;

public class ConstantPopulation
extends DemographicFunction.Abstract {
    private double N0;

    public ConstantPopulation(Units.Type type) {
        super(type);
    }

    public double getN0() {
        return this.N0;
    }

    public void setN0(double d) {
        this.N0 = d;
    }

    @Override
    public double getDemographic(double d) {
        return this.getN0();
    }

    @Override
    public double getIntensity(double d) {
        return d / this.getN0();
    }

    @Override
    public double getInverseIntensity(double d) {
        return this.getN0() * d;
    }

    @Override
    public double getIntensityGradient(double d) {
        return 1.0 / this.getN0();
    }

    @Override
    public double getIntegral(double d, double d2) {
        return (d2 - d) / this.getN0();
    }

    @Override
    public int getNumArguments() {
        return 1;
    }

    @Override
    public String getArgumentName(int n) {
        return "N0";
    }

    @Override
    public double getArgument(int n) {
        return this.getN0();
    }

    @Override
    public void setArgument(int n, double d) {
        this.setN0(d);
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }

    public DemographicFunction getCopy() {
        ConstantPopulation constantPopulation = new ConstantPopulation(this.getUnits());
        constantPopulation.N0 = this.N0;
        return constantPopulation;
    }
}

