/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Statistic;

public class RatioStatistic
extends Statistic.Abstract {
    private int dimension = 0;
    private Statistic numerator = null;
    private Statistic denominator = null;

    public RatioStatistic(String string, Statistic statistic, Statistic statistic2) {
        super(string);
        this.numerator = statistic;
        this.denominator = statistic2;
        if (statistic2.getDimension() != 1 && statistic.getDimension() != 1 && statistic2.getDimension() != statistic.getDimension()) {
            throw new IllegalArgumentException();
        }
        this.dimension = statistic2.getDimension() == 1 ? statistic.getDimension() : statistic2.getDimension();
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public double getStatisticValue(int n) {
        if (this.numerator.getDimension() == 1) {
            return this.numerator.getStatisticValue(0) / this.denominator.getStatisticValue(n);
        }
        if (this.denominator.getDimension() == 1) {
            return this.numerator.getStatisticValue(n) / this.denominator.getStatisticValue(0);
        }
        return this.numerator.getStatisticValue(n) / this.denominator.getStatisticValue(n);
    }
}

