/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceException;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class GeneralizedSteppingStoneSamplingAnalysis
implements Reportable {
    public static final String GENERALIZED_STEPPING_STONE_SAMPLING_ANALYSIS = "generalizedSteppingStoneSamplingAnalysis";
    public static final String RESULT_FILE_NAME = "resultsFileName";
    public static final String THETA_COLUMN = "thetaColumn";
    public static final String SOURCE_COLUMN = "sourceColumn";
    public static final String DESTINATION_COLUMN = "destinationColumn";
    public static final String FORMAT = "%5.5g";
    private final String sourceName;
    private final String destinationName;
    private final List<Double> thetaSample;
    private final List<Double> sourceSample;
    private final List<Double> destinationSample;
    private boolean logBayesFactorCalculated = false;
    private double logBayesFactor;
    private List<Double> maxLogLikelihood;
    private List<Double> orderedTheta;
    private List<Double> mlContribution;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("fileName", "The traceName of a BEAST log file (can not include trees, which should be logged separately)"), new StringAttributeRule("resultsFileName", "The name of the output file to which the generalized stepping-stone sampling estimate will be written", true), new ElementRule("thetaColumn", new XMLSyntaxRule[]{new StringAttributeRule("name", "The column name")}), new ElementRule("sourceColumn", new XMLSyntaxRule[]{new StringAttributeRule("name", "The column name")}), new ElementRule("destinationColumn", new XMLSyntaxRule[]{new StringAttributeRule("name", "The column name")})};

        @Override
        public String getParserName() {
            return GeneralizedSteppingStoneSamplingAnalysis.GENERALIZED_STEPPING_STONE_SAMPLING_ANALYSIS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute("fileName");
            String string2 = null;
            if (xMLObject.hasAttribute(GeneralizedSteppingStoneSamplingAnalysis.RESULT_FILE_NAME)) {
                string2 = xMLObject.getStringAttribute(GeneralizedSteppingStoneSamplingAnalysis.RESULT_FILE_NAME);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            System.out.println(n + " file(s) found with marginal likelihood samples");
            try {
                Object object;
                Object object2;
                String string3 = "";
                String string4 = "";
                List<Double> list = null;
                List<Double> list2 = null;
                List<Double> list3 = null;
                for (int i = 0; i < n; ++i) {
                    object2 = new File(stringTokenizer.nextToken());
                    object = ((File)object2).getName();
                    String string5 = ((File)object2).getParent();
                    if (!((File)object2).isAbsolute()) {
                        string5 = string5 == null ? System.getProperty("user.dir") : Paths.get(System.getProperty("user.dir"), string5).toString();
                    }
                    String string6 = System.getProperty("file.name.prefix");
                    String string7 = System.getProperty("file.separator");
                    if (string6 != null) {
                        if (string6.trim().length() == 0 || string6.contains(string7)) {
                            throw new XMLParseException("The specified file name prefix is illegal.");
                        }
                        object2 = new File(string5, string6 + (String)object);
                    } else {
                        object2 = new File(string5, (String)object);
                    }
                    string = ((File)object2).getAbsolutePath();
                    XMLObject xMLObject2 = xMLObject.getChild(GeneralizedSteppingStoneSamplingAnalysis.SOURCE_COLUMN);
                    string3 = xMLObject2.getStringAttribute("name");
                    xMLObject2 = xMLObject.getChild(GeneralizedSteppingStoneSamplingAnalysis.DESTINATION_COLUMN);
                    string4 = xMLObject2.getStringAttribute("name");
                    xMLObject2 = xMLObject.getChild(GeneralizedSteppingStoneSamplingAnalysis.THETA_COLUMN);
                    String string8 = xMLObject2.getStringAttribute("name");
                    LogFileTraces logFileTraces = new LogFileTraces(string, (File)object2);
                    logFileTraces.loadTraces();
                    long l = 0L;
                    logFileTraces.setBurnIn(l);
                    int n2 = -1;
                    int n3 = -1;
                    int n4 = -1;
                    for (int j = 0; j < logFileTraces.getTraceCount(); ++j) {
                        String string9 = logFileTraces.getTraceName(j);
                        if (string9.trim().equals(string8)) {
                            n2 = j;
                        }
                        if (string9.trim().equals(string3)) {
                            n3 = j;
                        }
                        if (!string9.trim().equals(string4)) continue;
                        n4 = j;
                    }
                    if (n2 == -1) {
                        throw new XMLParseException("Column '" + string8 + "' can not be found for " + this.getParserName() + " element.");
                    }
                    if (n3 == -1) {
                        throw new XMLParseException("Column '" + string3 + "' can not be found for " + this.getParserName() + " element.");
                    }
                    if (n4 == -1) {
                        throw new XMLParseException("Column '" + string4 + "' can not be found for " + this.getParserName() + " element.");
                    }
                    if (list == null && list2 == null && list3 == null) {
                        list = logFileTraces.getValues(n2);
                        list2 = logFileTraces.getValues(n3);
                        list3 = logFileTraces.getValues(n4);
                        continue;
                    }
                    list.addAll(logFileTraces.getValues(n2));
                    list2.addAll(logFileTraces.getValues(n3));
                    list3.addAll(logFileTraces.getValues(n4));
                }
                GeneralizedSteppingStoneSamplingAnalysis generalizedSteppingStoneSamplingAnalysis = new GeneralizedSteppingStoneSamplingAnalysis(string3, string4, list, list2, list3);
                System.out.println(generalizedSteppingStoneSamplingAnalysis.toString());
                if (string2 != null) {
                    object2 = new FileWriter(string2, true);
                    object = new BufferedWriter((Writer)object2);
                    ((Writer)object).write(generalizedSteppingStoneSamplingAnalysis.toString());
                    ((BufferedWriter)object).flush();
                    ((BufferedWriter)object).close();
                }
                return generalizedSteppingStoneSamplingAnalysis;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLParseException("File '" + string + "' can not be opened for " + this.getParserName() + " element.");
            }
            catch (IOException iOException) {
                throw new XMLParseException(iOException.getMessage());
            }
            catch (TraceException traceException) {
                throw new XMLParseException(traceException.getMessage());
            }
        }

        @Override
        public String getParserDescription() {
            return "Performs a trace analysis.";
        }

        @Override
        public Class getReturnType() {
            return GeneralizedSteppingStoneSamplingAnalysis.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public GeneralizedSteppingStoneSamplingAnalysis(String string, String string2, List<Double> list, List<Double> list2, List<Double> list3) {
        this.sourceName = string;
        this.destinationName = string2;
        this.thetaSample = list;
        this.sourceSample = list2;
        this.destinationSample = list3;
    }

    public double getLogBayesFactor() {
        if (!this.logBayesFactorCalculated) {
            this.calculateBF();
        }
        return this.logBayesFactor;
    }

    private void calculateBF() {
        int n;
        double d2;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.orderedTheta = new ArrayList<Double>();
        for (int i = 0; i < this.sourceSample.size(); ++i) {
            if (!hashMap.containsKey(this.thetaSample.get(i))) {
                hashMap.put(this.thetaSample.get(i), new ArrayList());
                hashMap2.put(this.thetaSample.get(i), new ArrayList());
                this.orderedTheta.add(this.thetaSample.get(i));
            }
            ((List)hashMap.get(this.thetaSample.get(i))).add(this.sourceSample.get(i) - this.destinationSample.get(i));
            ((List)hashMap2.get(this.thetaSample.get(i))).add(this.sourceSample.get(i));
        }
        Collections.sort(this.orderedTheta);
        System.out.println("Test source column:");
        this.maxLogLikelihood = new ArrayList<Double>();
        for (double d2 : this.orderedTheta) {
            List list = (List)hashMap.get(d2);
            this.maxLogLikelihood.add((Double)Collections.max(list));
            System.out.println(Collections.max((Collection)hashMap2.get(d2)));
        }
        System.out.println("Number of maximum loglikelihoods: " + this.maxLogLikelihood.size());
        for (double d2 : this.maxLogLikelihood) {
            System.out.println(d2);
        }
        this.mlContribution = new ArrayList<Double>();
        this.logBayesFactor = 0.0;
        for (n = 1; n < this.orderedTheta.size(); ++n) {
            d2 = (this.orderedTheta.get(n) - this.orderedTheta.get(n - 1)) * this.maxLogLikelihood.get(n - 1);
            this.logBayesFactor += d2;
            this.mlContribution.add(d2);
        }
        for (n = 1; n < this.orderedTheta.size(); ++n) {
            d2 = 0.0;
            for (int i = 0; i < ((List)hashMap.get(this.orderedTheta.get(n - 1))).size(); ++i) {
                d2 += Math.exp((this.orderedTheta.get(n) - this.orderedTheta.get(n - 1)) * ((Double)((List)hashMap.get(this.orderedTheta.get(n - 1))).get(i) - this.maxLogLikelihood.get(n - 1)));
            }
            this.mlContribution.set(n - 1, this.mlContribution.get(n - 1) + Math.log(d2 /= (double)((List)hashMap.get(this.orderedTheta.get(n - 1))).size()));
            this.logBayesFactor += Math.log(d2);
        }
        this.logBayesFactorCalculated = true;
    }

    public String toString() {
        double d = this.getLogBayesFactor();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PathParameter\tMaxPathLikelihood\tMLContribution\n");
        for (int i = 0; i < this.orderedTheta.size(); ++i) {
            stringBuffer.append(String.format(FORMAT, this.orderedTheta.get(i)));
            stringBuffer.append("\t");
            stringBuffer.append(String.format(FORMAT, this.maxLogLikelihood.get(i)));
            stringBuffer.append("\t");
            if (i != this.orderedTheta.size() - 1) {
                stringBuffer.append(String.format(FORMAT, this.mlContribution.get(i)));
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nlog marginal likelihood (using generalized stepping stone sampling) from (" + this.sourceName + " - " + this.destinationName + ") = " + d + "\n");
        return stringBuffer.toString();
    }

    @Override
    public String getReport() {
        return this.toString();
    }
}

