/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.List;

public class MultiplicativeBranchRateModel
extends AbstractBranchRateModel {
    private final List<AbstractBranchRateModel> branchRateModels;
    private final int dim;

    public MultiplicativeBranchRateModel(List<AbstractBranchRateModel> list) {
        super("multiplicativeBranchRates");
        this.branchRateModels = list;
        this.dim = list.size();
        for (AbstractBranchRateModel abstractBranchRateModel : list) {
            this.addModel(abstractBranchRateModel);
        }
        if (this.dim != 2) {
            throw new RuntimeException("Not yet tested.  Be careful with underflow errors.");
        }
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        double d = this.branchRateModels.get(0).getBranchRate(tree, nodeRef);
        for (int i = 1; i < this.dim; ++i) {
            d *= this.branchRateModels.get(i).getBranchRate(tree, nodeRef);
        }
        return d;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }
}

