/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.hmc;

import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.BranchSpecificGradient;
import dr.evomodel.treedatalikelihood.hmc.AbstractDiffusionGradient;
import dr.inference.hmc.CompoundGradient;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.xml.Reportable;

public class DiffusionParametersGradient
implements GradientWrtParameterProvider,
Reportable {
    private final TreeDataLikelihood likelihood;
    private final int dim;
    private final BranchSpecificGradient branchSpecificGradient;
    private final CompoundParameter compoundParameter;
    private final CompoundGradient parametersGradients;

    public DiffusionParametersGradient(BranchSpecificGradient branchSpecificGradient, CompoundGradient compoundGradient) {
        this.branchSpecificGradient = branchSpecificGradient;
        this.likelihood = (TreeDataLikelihood)branchSpecificGradient.getLikelihood();
        this.compoundParameter = new CompoundParameter(null);
        this.dim = this.checkAndSetParametersGradients(compoundGradient, this.compoundParameter);
        this.parametersGradients = compoundGradient;
    }

    private int checkAndSetParametersGradients(CompoundGradient compoundGradient, CompoundParameter compoundParameter) {
        int n = 0;
        int n2 = 0;
        int n3 = this.likelihood.getDataLikelihoodDelegate().getTraitDim();
        for (GradientWrtParameterProvider gradientWrtParameterProvider : compoundGradient.getDerivativeList()) {
            assert (gradientWrtParameterProvider instanceof AbstractDiffusionGradient) : "Gradients must all be instances of AbstractDiffusionGradient.";
            ((AbstractDiffusionGradient)gradientWrtParameterProvider).setOffset(n);
            compoundParameter.addParameter(gradientWrtParameterProvider.getParameter());
            n += ((AbstractDiffusionGradient)gradientWrtParameterProvider).getDerivationParameter().getDimension(n3);
            n2 += gradientWrtParameterProvider.getDimension();
        }
        return n2;
    }

    @Override
    public Likelihood getLikelihood() {
        return this.likelihood;
    }

    @Override
    public Parameter getParameter() {
        return this.compoundParameter;
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public double[] getGradientLogDensity() {
        double[] dArray = this.branchSpecificGradient.getGradientLogDensity();
        return this.getGradientLogDensity(dArray);
    }

    private double[] getGradientLogDensity(double[] dArray) {
        double[] dArray2 = new double[this.dim];
        int n = 0;
        for (GradientWrtParameterProvider gradientWrtParameterProvider : this.parametersGradients.getDerivativeList()) {
            System.arraycopy(((AbstractDiffusionGradient)gradientWrtParameterProvider).getGradientLogDensity(dArray), 0, dArray2, n, gradientWrtParameterProvider.getDimension());
            n += gradientWrtParameterProvider.getDimension();
        }
        return dArray2;
    }

    @Override
    public String getReport() {
        return "diffusionGradient." + this.compoundParameter.getParameterName() + "\n" + GradientWrtParameterProvider.getReportAndCheckForError(this, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, GradientWrtParameterProvider.TOLERANCE);
    }
}

