/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.AscertainedSitePatterns;
import dr.evolution.alignment.PatternList;
import dr.evolution.util.TaxonList;
import dr.util.Citable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ContentRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class AscertainedSitePatternsParser
extends AbstractXMLObjectParser {
    public static final String APATTERNS = "ascertainedPatterns";
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String EVERY = "every";
    public static final String TAXON_LIST = "taxonList";
    public static final String INCLUDE = "includePatterns";
    public static final String EXCLUDE = "excludePatterns";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("from", true, "The site position to start at, default is 1 (the first position)"), AttributeRule.newIntegerRule("to", true, "The site position to finish at, must be greater than <b>from</b>, default is length of given alignment"), AttributeRule.newIntegerRule("every", true, "Determines how many sites are selected. A value of 3 will select every third site starting from <b>from</b>, default is 1 (every site)"), new ElementRule("taxonList", new XMLSyntaxRule[]{new ElementRule(TaxonList.class)}, true), new ElementRule(Alignment.class), new ContentRule("<includePatterns from=\"Z\" to=\"X\"/>"), new ContentRule("<excludePatterns from=\"Z\" to=\"X\"/>")};

    @Override
    public String getParserName() {
        return APATTERNS;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        XMLObject xMLObject2;
        Alignment alignment = (Alignment)xMLObject.getChild(Alignment.class);
        TaxonList taxonList = null;
        int n = -1;
        int n2 = -1;
        int n3 = xMLObject.getAttribute(EVERY, 1);
        if (n3 <= 0) {
            throw new XMLParseException("illegal 'every' attribute in patterns element");
        }
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        if (xMLObject.hasAttribute(FROM) && (n = xMLObject.getIntegerAttribute(FROM) - 1) < 0) {
            throw new XMLParseException("illegal 'from' attribute in patterns element");
        }
        if (xMLObject.hasAttribute(TO) && ((n2 = xMLObject.getIntegerAttribute(TO) - 1) < 0 || n2 < n)) {
            throw new XMLParseException("illegal 'to' attribute in patterns element");
        }
        if (xMLObject.hasChildNamed(TAXON_LIST)) {
            taxonList = (TaxonList)xMLObject.getElementFirstChild(TAXON_LIST);
        }
        if (n > alignment.getSiteCount()) {
            throw new XMLParseException("illegal 'from' attribute in patterns element");
        }
        if (n2 > alignment.getSiteCount()) {
            throw new XMLParseException("illegal 'to' attribute in patterns element");
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = alignment.getSiteCount() - 1;
        }
        Logger.getLogger("dr.evoxml").info("Creating ascertained site patterns '" + xMLObject.getId() + "' from positions " + Integer.toString(n + 1) + "-" + Integer.toString(n2 + 1) + " of alignment '" + alignment.getId() + "'");
        if (n3 > 1) {
            Logger.getLogger("dr.evoxml").info("  only using every " + n3 + " site");
        }
        if (xMLObject.hasChildNamed(INCLUDE)) {
            xMLObject2 = xMLObject.getChild(INCLUDE);
            if (!xMLObject2.hasAttribute(FROM) || !xMLObject2.hasAttribute(TO)) {
                throw new XMLParseException("both from and to attributes are required for includePatterns");
            }
            n4 = xMLObject2.getIntegerAttribute(FROM) - 1;
            n5 = xMLObject2.getIntegerAttribute(TO);
            if (n4 < 0 || n5 < n4) {
                throw new XMLParseException("invalid 'from' and 'to' attributes in includePatterns");
            }
            Logger.getLogger("dr.evoxml").info("\tAscertainment: Patterns in columns " + (n4 + 1) + " to " + n5 + " are only possible. ");
        }
        if (xMLObject.hasChildNamed(EXCLUDE)) {
            xMLObject2 = xMLObject.getChild(EXCLUDE);
            if (!xMLObject2.hasAttribute(FROM) || !xMLObject2.hasAttribute(TO)) {
                throw new XMLParseException("both from and to attributes are required for excludePatterns");
            }
            n6 = xMLObject2.getIntegerAttribute(FROM) - 1;
            n7 = xMLObject2.getIntegerAttribute(TO);
            if (n6 < 0 || n7 < n6) {
                throw new XMLParseException("invalid 'from' and 'to' attributes in includePatterns");
            }
            Logger.getLogger("dr.evoxml").info("\tAscertainment: Patterns in columns " + (n6 + 1) + " to " + n7 + " are not possible. ");
        }
        AscertainedSitePatterns ascertainedSitePatterns = new AscertainedSitePatterns(alignment, taxonList, n, n2, n3, n4, n5, n6, n7);
        Logger.getLogger("dr.evoxml").info("\tThere are " + ascertainedSitePatterns.getPatternCount() + " patterns in total.");
        Logger.getLogger("dr.evoxml").info("\tPlease cite:\n" + Citable.Utils.getCitationString(ascertainedSitePatterns));
        return ascertainedSitePatterns;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "A weighted list of the unique site patterns (unique columns) in an alignment.";
    }

    @Override
    public Class getReturnType() {
        return PatternList.class;
    }
}

