/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel.shrinkage;

import dr.evomodel.branchratemodel.AutoCorrelatedBranchRatesDistribution;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class IncrementLogger
implements Loggable {
    private final AutoCorrelatedBranchRatesDistribution distribution;
    private static final String INCREMENT_PARAMETER = "incrementParameter";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(AutoCorrelatedBranchRatesDistribution.class)};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AutoCorrelatedBranchRatesDistribution autoCorrelatedBranchRatesDistribution = (AutoCorrelatedBranchRatesDistribution)xMLObject.getChild(AutoCorrelatedBranchRatesDistribution.class);
            return new IncrementLogger(autoCorrelatedBranchRatesDistribution);
        }

        @Override
        public String getParserName() {
            return IncrementLogger.INCREMENT_PARAMETER;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Logs the increments of auto-correlated branch rate model";
        }

        @Override
        public Class getReturnType() {
            return IncrementLogger.class;
        }
    };

    public IncrementLogger(AutoCorrelatedBranchRatesDistribution autoCorrelatedBranchRatesDistribution) {
        this.distribution = autoCorrelatedBranchRatesDistribution;
    }

    @Override
    public LogColumn[] getColumns() {
        int n = this.distribution.getDimension();
        LogColumn[] logColumnArray = new LogColumn[n];
        for (int i = 0; i < n; ++i) {
            final int n2 = i;
            logColumnArray[i] = new NumberColumn("increment." + n2){

                @Override
                public double getDoubleValue() {
                    return IncrementLogger.this.distribution.getIncrement(n2);
                }
            };
        }
        return logColumnArray;
    }
}

