/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.NoSuchElementException;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
public final class CharacterWalker {
    CharacterSet charSet;
    byte[] bytes;
    int next;
    int end;
    int shiftstate;

    public CharacterWalker(CharacterSet characterSet, byte[] byArray, int n2, int n3) {
        this.charSet = characterSet;
        this.bytes = byArray;
        this.next = n2;
        this.end = n2 + n3;
        if (this.next < 0) {
            this.next = 0;
        }
        if (this.end > byArray.length) {
            this.end = byArray.length;
        }
    }

    public int nextCharacter() throws NoSuchElementException {
        try {
            return this.charSet.decode(this);
        }
        catch (SQLException sQLException) {
            throw new NoSuchElementException(sQLException.getMessage());
        }
    }

    public boolean hasMoreCharacters() {
        return this.next < this.end;
    }
}

