/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.border;

import ch.randelshofer.quaqua.border.ImageBevelBorder;
import ch.randelshofer.quaqua.border.VisualMarginBorder;
import ch.randelshofer.quaqua.osx.OSXAquaPainter;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.image.BufferedImage;

public class QuaquaNativeImageBevelBorder
extends VisualMarginBorder
implements javax.swing.plaf.UIResource {
    private OSXAquaPainter.Widget widget;
    private ImageBevelBorder imageBevelBorder;
    private Insets painterInsets;
    private Insets imageBevelInsets;
    private Insets borderInsets;
    private Insets visualMargin;
    private boolean fill;

    public QuaquaNativeImageBevelBorder(OSXAquaPainter.Widget widget, Insets painterInsets, Insets imageBevelInsets, Insets borderInsets, boolean fill) {
        this.widget = widget;
        this.painterInsets = painterInsets;
        this.imageBevelInsets = imageBevelInsets;
        this.borderInsets = borderInsets;
        this.visualMargin = new Insets(3, 3, 3, 3);
        this.fill = fill;
    }

    public void paintBorder(Component cc, Graphics g, int x, int y, int width, int height) {
        if (this.imageBevelBorder == null) {
            this.imageBevelBorder = this.createImageBeveBorder();
        }
        this.imageBevelBorder.paintBorder(cc, g, x, y, width, height);
    }

    protected ImageBevelBorder createImageBeveBorder() {
        OSXAquaPainter painter = new OSXAquaPainter();
        painter.setWidget(this.widget);
        int fixedWidth = 32;
        int fixedHeight = 32;
        BufferedImage image = new BufferedImage(fixedWidth, fixedHeight, 3);
        painter.paint(image, this.painterInsets.left, this.painterInsets.top, image.getWidth() - this.painterInsets.left - this.painterInsets.right, image.getHeight() - this.painterInsets.top - this.painterInsets.bottom);
        ImageBevelBorder ibb = new ImageBevelBorder(image, this.imageBevelInsets, this.borderInsets, this.fill);
        return ibb;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        Insets ins = super.getBorderInsets(c, insets);
        InsetsUtil.addTo(this.borderInsets, ins);
        return ins;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public static class UIResource
    extends QuaquaNativeImageBevelBorder
    implements javax.swing.plaf.UIResource {
        public UIResource(OSXAquaPainter.Widget widget, Insets painterInsets, Insets imageBevelInsets, Insets borderInsets, boolean fill) {
            super(widget, painterInsets, imageBevelInsets, borderInsets, fill);
        }
    }
}

