/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.simprocs.ProcessSimulator;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.simprocs.SimThread;

public class ThreadProcessSimulator
extends ProcessSimulator {
    private SimThread threadAllHead = null;

    public void init() {
        super.init();
    }

    public void init(EventList eventList) {
        super.init(eventList);
    }

    public SimThread createControlEvent(SimProcess simProcess) {
        return SimThread.getThread(simProcess, this);
    }

    public void delay(SimProcess simProcess, double d) {
        if (this.currentProcess != simProcess) {
            throw new IllegalStateException("Calling delay() for a process not in EXECUTING state");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Calling delay() with negative delay");
        }
        simProcess.scheduledEvent().schedule(d);
        this.dispatch();
        ((SimThread)simProcess.scheduledEvent()).passivate();
    }

    public void suspend(SimProcess simProcess) {
        SimThread simThread = (SimThread)simProcess.scheduledEvent();
        if (simThread == null) {
            throw new IllegalStateException("Calling suspend() for a dead process");
        }
        if (this.currentProcess == simProcess) {
            this.dispatch();
            simThread.passivate();
            return;
        }
        if (simThread.time() >= 0.0) {
            simThread.cancel();
            simThread.setTime(-10.0);
            return;
        }
        if (simThread.time() == -20.0) {
            throw new IllegalStateException("Calling suspend() for a process in INITIAL state");
        }
        throw new IllegalStateException("Calling suspend() for a suspended process");
    }

    public void kill(SimProcess simProcess) {
        if (simProcess.scheduledEvent() == null) {
            throw new IllegalStateException("cannot kill a DEAD process");
        }
        ((SimThread)simProcess.scheduledEvent()).kill();
    }

    public void killAll() {
        SimThread.killAll(this);
    }

    protected void dispatch() {
        Event event;
        while ((event = this.removeFirstEvent()) != null) {
            if (event instanceof SimThread) {
                this.currentProcess = ((SimThread)event).myProcess;
                ((SimThread)event).activate();
                return;
            }
            event.actions();
        }
        SimThread.simActivate(this);
    }

    protected SimThread threadAllHead() {
        return this.threadAllHead;
    }

    protected void setThreadAllHead(SimThread simThread) {
        this.threadAllHead = simThread;
    }
}

