/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat;

import java.util.logging.Level;
import java.util.logging.Logger;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.stat.StatProbe;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.stat.list.ListOfTalliesWithCovariance;
import umontreal.iro.lecuyer.util.MultivariateFunction;
import umontreal.iro.lecuyer.util.PrintfFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionOfMultipleMeansTally
extends StatProbe
implements Cloneable {
    private ListOfTalliesWithCovariance<Tally> ta;
    protected MultivariateFunction func;
    private double[] temp;
    private double[] delta;
    private Logger log = Logger.getLogger("umontreal.iro.lecuyer.stat");
    protected CIType confidenceInterval = CIType.CI_NONE;
    protected double level = 0.95;

    public FunctionOfMultipleMeansTally(MultivariateFunction multivariateFunction, int n) {
        this.ta = ListOfTalliesWithCovariance.createWithTally(n);
        this.ta.setUnmodifiable();
        this.func = multivariateFunction;
        this.internalInit();
    }

    public FunctionOfMultipleMeansTally(MultivariateFunction multivariateFunction, String string, int n) {
        this.ta = ListOfTalliesWithCovariance.createWithTally(n);
        this.ta.setName(string);
        this.ta.setUnmodifiable();
        this.func = multivariateFunction;
        this.name = string;
        this.internalInit();
    }

    public FunctionOfMultipleMeansTally(MultivariateFunction multivariateFunction, ListOfTalliesWithCovariance<Tally> listOfTalliesWithCovariance) {
        if (listOfTalliesWithCovariance == null) {
            throw new NullPointerException("The list of tallies cannot be null");
        }
        this.ta = listOfTalliesWithCovariance;
        this.func = multivariateFunction;
        listOfTalliesWithCovariance.setUnmodifiable();
        this.name = listOfTalliesWithCovariance.getName();
        this.internalInit();
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.ta.setName(string);
    }

    public ListOfTalliesWithCovariance<Tally> getListOfTallies() {
        return this.ta;
    }

    public MultivariateFunction getFunction() {
        return this.func;
    }

    public int getDimension() {
        return this.ta.size();
    }

    public void add(double ... dArray) {
        if (dArray.length != this.ta.size()) {
            throw new IllegalArgumentException("Incompatible length of vectors of observations: given length is " + dArray.length + ", but required length is " + this.ta.size());
        }
        if (this.collect) {
            this.ta.add(dArray);
        }
    }

    public int numberObs() {
        return this.ta.numberObs();
    }

    @Override
    public double average() {
        if (this.temp.length != this.ta.size()) {
            this.temp = new double[this.ta.size()];
        }
        this.ta.average(this.temp);
        return this.func.evaluate(this.temp);
    }

    public double variance() {
        int n;
        if (this.ta.numberObs() < 2) {
            this.log.logp(Level.WARNING, "FunctionOfMultipleMeansTally", "variance", "FunctionOfMultipleMeansTally " + this.name + ":   calling variance() with " + this.ta.numberObs() + " observation");
            return Double.NaN;
        }
        if (this.temp.length != this.ta.size()) {
            this.temp = new double[this.ta.size()];
            this.delta = new double[this.ta.size()];
        }
        this.ta.average(this.temp);
        for (n = 0; n < this.delta.length; ++n) {
            this.delta[n] = this.func.evaluateGradient(n, this.temp);
        }
        for (n = 0; n < this.temp.length; ++n) {
            this.temp[n] = 0.0;
            for (int i = 0; i < this.delta.length; ++i) {
                int n2 = n;
                this.temp[n2] = this.temp[n2] + this.delta[i] * this.ta.covariance(i, n);
            }
        }
        double d = 0.0;
        for (int i = 0; i < this.temp.length; ++i) {
            d += this.temp[i] * this.delta[i];
        }
        return d < 0.0 ? 0.0 : d;
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public void confidenceIntervalDelta(double d, double[] dArray) {
        dArray[0] = this.average();
        double d2 = NormalDist.inverseF01(0.5 * (d + 1.0));
        dArray[1] = d2 * Math.sqrt(this.variance() / (double)this.numberObs());
    }

    public String formatConfidenceIntervalDelta(double d, int n) {
        PrintfFormat printfFormat = new PrintfFormat();
        double[] dArray = new double[2];
        this.confidenceIntervalDelta(d, dArray);
        printfFormat.append("  " + 100.0 * d + "%");
        printfFormat.append(" confidence interval for function of means: (");
        printfFormat.append(7 + n, n, n - 1, dArray[0] - dArray[1]).append(',');
        printfFormat.append(7 + n, n, n - 1, dArray[0] + dArray[1]).append(" )\n");
        return printfFormat.toString();
    }

    public String formatConfidenceIntervalDelta(double d) {
        return this.formatConfidenceIntervalDelta(d, 3);
    }

    public String formatCIDelta(double d, int n) {
        return this.formatConfidenceIntervalDelta(d, n);
    }

    public String formatCIDelta(double d) {
        return this.formatConfidenceIntervalDelta(d);
    }

    @Override
    public String report() {
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append("REPORT on Tally stat. collector ==> " + this.name);
        printfFormat.append("\n    func. of averages    standard dev.  ");
        printfFormat.append("num. obs.\n");
        printfFormat.append(20, 3, 2, this.average());
        printfFormat.append(13, 3, 2, this.standardDeviation());
        printfFormat.append(13, this.numberObs()).append('\n');
        if (this.confidenceInterval == CIType.CI_DELTA) {
            printfFormat.append(this.formatConfidenceIntervalDelta(this.level));
        }
        return printfFormat.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String reportAndConfidenceIntervalDelta(double d, int n) {
        CIType cIType = this.confidenceInterval;
        double d2 = this.level;
        try {
            this.confidenceInterval = CIType.CI_DELTA;
            this.level = d;
            String string = this.report();
            return string;
        }
        finally {
            this.confidenceInterval = cIType;
            this.level = d2;
        }
    }

    public String reportAndConfidenceIntervalDelta(double d) {
        return this.reportAndConfidenceIntervalDelta(d, 3);
    }

    public String reportAndCIDelta(double d, int n) {
        return this.reportAndConfidenceIntervalDelta(d, n);
    }

    public String reportAndCIDelta(double d) {
        return this.reportAndConfidenceIntervalDelta(d);
    }

    @Override
    public String shortReportHeader() {
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append(-20, " func. of averages").append("   ");
        printfFormat.append(-9, "std. dev.");
        if (this.showNobs) {
            printfFormat.append("   ").append(-5, "nobs.");
        }
        if (this.confidenceInterval != CIType.CI_NONE) {
            printfFormat.append("   ").append(-25, "conf. int.");
        }
        return printfFormat.toString();
    }

    @Override
    public String shortReport() {
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append(20, 3, 2, this.average()).append("   ");
        if (this.numberObs() >= 2) {
            printfFormat.append(9, 3, 2, this.standardDeviation());
        } else {
            printfFormat.append(9, "---");
        }
        if (this.showNobs) {
            printfFormat.append("   ").append(5, this.numberObs());
        }
        if (this.confidenceInterval == CIType.CI_DELTA) {
            double[] dArray = new double[2];
            this.confidenceIntervalDelta(this.level, dArray);
            printfFormat.append("   ").append(100.0 * this.level + "% (");
            printfFormat.append(9, 3, 2, dArray[0] - dArray[1]).append(',');
            printfFormat.append(9, 3, 2, dArray[0] + dArray[1]).append(")");
        }
        return printfFormat.toString();
    }

    public double getConfidenceLevel() {
        return this.level;
    }

    public void setConfidenceLevel(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("level < 0");
        }
        if (d >= 1.0) {
            throw new IllegalArgumentException("level >= 1");
        }
        this.level = d;
    }

    public void setConfidenceIntervalNone() {
        this.confidenceInterval = CIType.CI_NONE;
    }

    public void setConfidenceIntervalDelta() {
        this.confidenceInterval = CIType.CI_DELTA;
    }

    public void setShowNumberObs(boolean bl) {
        this.showNobs = bl;
    }

    @Override
    public double min() {
        return Double.NaN;
    }

    @Override
    public double max() {
        return Double.NaN;
    }

    @Override
    public double sum() {
        return Double.NaN;
    }

    private void internalInit() {
        if (this.func.getDimension() != this.ta.size() && this.func.getDimension() != -1) {
            throw new IllegalArgumentException("The dimension of the function must be equal to d, or equal to -1");
        }
        this.temp = new double[this.ta.size()];
        this.delta = new double[this.ta.size()];
    }

    @Override
    public void init() {
        this.ta.init();
        this.internalInit();
    }

    @Override
    public FunctionOfMultipleMeansTally clone() {
        FunctionOfMultipleMeansTally functionOfMultipleMeansTally;
        try {
            functionOfMultipleMeansTally = (FunctionOfMultipleMeansTally)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("CloneNotSupportedException for a class implementing Cloneable");
        }
        functionOfMultipleMeansTally.ta = new ListOfTalliesWithCovariance();
        for (int i = 0; i < this.ta.size(); ++i) {
            functionOfMultipleMeansTally.ta.add(((Tally)this.ta.get(i)).clone());
        }
        functionOfMultipleMeansTally.temp = new double[this.ta.size()];
        functionOfMultipleMeansTally.delta = new double[this.ta.size()];
        return functionOfMultipleMeansTally;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CIType {
        CI_NONE,
        CI_DELTA;

    }
}

