/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.EmpiricalDist;
import umontreal.iro.lecuyer.randvar.KernelDensityGen;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class KernelDensityVarCorrectGen
extends KernelDensityGen {
    protected double sigmak2;
    protected double mean;
    protected double invSigmae;

    public KernelDensityVarCorrectGen(RandomStream randomStream, EmpiricalDist empiricalDist, RandomVariateGen randomVariateGen, double d, double d2) {
        super(randomStream, empiricalDist, randomVariateGen, d);
        this.sigmak2 = d2;
        this.mean = empiricalDist.getSampleMean();
        double d3 = empiricalDist.getSampleVariance();
        this.invSigmae = 1.0 / Math.sqrt(1.0 + d * d * d2 / d3);
    }

    public KernelDensityVarCorrectGen(RandomStream randomStream, EmpiricalDist empiricalDist, NormalGen normalGen) {
        this(randomStream, empiricalDist, normalGen, 0.77639 * KernelDensityVarCorrectGen.getBaseBandwidth(empiricalDist), 1.0);
    }

    public void setBandwidth(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("h < 0");
        }
        this.bandwidth = d;
        double d2 = ((EmpiricalDist)this.dist).getSampleVariance();
        this.invSigmae = 1.0 / Math.sqrt(1.0 + d * d * this.sigmak2 / d2);
    }

    public double nextDouble() {
        double d = this.mean + this.invSigmae * (this.dist.inverseF(this.stream.nextDouble()) - this.mean + this.bandwidth * this.kernelGen.nextDouble());
        if (this.positive) {
            return Math.abs(d);
        }
        return d;
    }
}

