## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

## -----------------------------------------------------------------------------
library(algebraic.dist)

## -----------------------------------------------------------------------------
x <- normal(0, 1)
y <- exponential(1)
z <- x + y

## -----------------------------------------------------------------------------
is_edist(z)
class(z)

## -----------------------------------------------------------------------------
set.seed(1)
mean(z)
vcov(z)

## -----------------------------------------------------------------------------
z <- normal(1, 4) + normal(2, 5)
is_normal(z)
z
mean(z)
vcov(z)

## -----------------------------------------------------------------------------
z <- normal(1, 4) - normal(2, 5)
z
mean(z)
vcov(z)

## -----------------------------------------------------------------------------
z <- 3 * normal(2, 1)
z
mean(z)
vcov(z)

## -----------------------------------------------------------------------------
z <- normal(5, 2) + 10
z
mean(z)
vcov(z)

## -----------------------------------------------------------------------------
z <- exponential(2) + exponential(2)
is_gamma_dist(z)
z
params(z)

## -----------------------------------------------------------------------------
z <- gamma_dist(3, 2) + exponential(2)
z
params(z)

## -----------------------------------------------------------------------------
z <- gamma_dist(3, 2) + gamma_dist(4, 2)
z
params(z)

## -----------------------------------------------------------------------------
z <- exp(normal(0, 1))
is_lognormal(z)
z

## -----------------------------------------------------------------------------
z <- log(lognormal(0, 1))
is_normal(z)
z

## -----------------------------------------------------------------------------
z <- normal(0, 1)^2
is_chi_squared(z)
z

## -----------------------------------------------------------------------------
z <- chi_squared(3) + chi_squared(5)
is_chi_squared(z)
z
params(z)

## -----------------------------------------------------------------------------
z <- poisson_dist(2) + poisson_dist(3)
is_poisson_dist(z)
z
params(z)

## -----------------------------------------------------------------------------
z <- lognormal(0, 1) * lognormal(1, 2)
is_lognormal(z)
z
params(z)

## -----------------------------------------------------------------------------
z <- 2 * uniform_dist(0, 1)
is_uniform_dist(z)
z
params(z)

## -----------------------------------------------------------------------------
z <- uniform_dist(0, 1) + 5
is_uniform_dist(z)
z
params(z)

## -----------------------------------------------------------------------------
z <- normal(0, 1) * exponential(1)
is_edist(z)

## -----------------------------------------------------------------------------
set.seed(2)
mean(z)

## -----------------------------------------------------------------------------
set.seed(3)
z <- normal(0, 1) * exponential(1)
rd <- realize(z, n = 10000)
rd
mean(rd)
vcov(rd)

## -----------------------------------------------------------------------------
set.seed(4)
z <- normal(0, 1) + exponential(1)
Fz <- cdf(z)
Fz(1)
Fz(2)

## -----------------------------------------------------------------------------
z <- min(exponential(1), exponential(2))
is_exponential(z)
z
params(z)

## -----------------------------------------------------------------------------
z <- sum(normal(0, 1), normal(2, 3), normal(-1, 2))
is_normal(z)
z
mean(z)
vcov(z)

## -----------------------------------------------------------------------------
set.seed(5)
z <- max(exponential(1), exponential(2))
is_edist(z)
mean(z)

## -----------------------------------------------------------------------------
z <- clt(exponential(1))
z
mean(z)
vcov(z)

## -----------------------------------------------------------------------------
d <- lln(exponential(1))
d
mean(d)
vcov(d)

## -----------------------------------------------------------------------------
z <- delta_clt(exponential(1), g = exp, dg = exp)
z
mean(z)
vcov(z)

## -----------------------------------------------------------------------------
g <- gamma_dist(5, 2)
n <- normal_approx(g)
n
mean(n)
vcov(n)

## -----------------------------------------------------------------------------
set.seed(42)
base <- exponential(rate = 1)
ns <- c(10, 100, 1000)
for (n in ns) {
  samp_means <- replicate(5000, {
    x <- sampler(base)(n)
    sqrt(n) * (mean(x) - mean(base))
  })
  cat(sprintf("n=%4d: mean=%.3f, var=%.3f\n",
              n, mean(samp_means), var(samp_means)))
}

## -----------------------------------------------------------------------------
z <- clt(base)
cat(sprintf("CLT:    mean=%.3f, var=%.3f\n", mean(z), vcov(z)))

