## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library("exams.forge.data")

## ----sos----------------------------------------------------------------------
data("sos100")
str(sos100)
# sum_i x_i
head(rowSums(sos100, na.rm=TRUE))
# sum_i x_i^2
head(rowSums(sos100^2, na.rm=TRUE))
# number of non-missing observations
head(rowSums(!is.na(sos100)))

## ----eval=FALSE---------------------------------------------------------------
# library("exams.forge")   # version 1.0.12 is required
# # Retrieve or compute the dataset for n = 200
# sos200 <- sos(200)
# # With a custom nmax
# sos_custom <- sos(150, nmax = 12)

## ----echo=FALSE---------------------------------------------------------------
library("knitr")
files <- list.files(path = system.file("aufgaben", package = "exams.forge.data"), pattern = "\\.Rmd$", recursive = TRUE, full.names = FALSE)
tab   <- table(dirname(files))
df    <- data.frame(Topic=names(tab), Exercises=as.integer(tab))               
kable(df, format = "markdown")

## ----topic--------------------------------------------------------------------
head(view("topic"))

## ----file---------------------------------------------------------------------
head(view("file", pattern = "ttest"))

## ----html, eval=FALSE---------------------------------------------------------
# view("html", pattern = "hyper")

## ----pdf, eval=FALSE----------------------------------------------------------
# view("pdf", pattern = "ttest")

## ----workflow, eval=FALSE-----------------------------------------------------
# # 1. List all topics
# topics <- view("topic")
# 
# # 2. Select exercises from a specific topic
# files <- view("file", pattern = "ttest", topic = TRUE)
# 
# # 3. Render them to HTML
# view("html", pattern = "ttest")

## ----all, eval=FALSE----------------------------------------------------------
# library("exams")
# library("exams.forge")
# path  <- system.file("aufgaben", package="exams.forge.data")
# files <- list.files(path=path, pattern="\\.Rmd$", recursive = TRUE, full.names = TRUE)
# # Render all 500+ exercises
# cwd <- setwd(path)
# set.seed(0) # get the same exercises as in PDF
# exams2html(files, verbose=TRUE)
# # Render all exercises as PDF using a custom LaTeX template
# # (required because 'exams' does not support \usepackage[xtable]{xcolor})
# set.seed(0) # get the same exercises as in HTML
# tmpl <- system.file("aufgaben", "plain.tex", package="exams.forge.data")
# exams2pdf(files, template=tmpl, verbose=TRUE)
# setwd(cwd)

