#' @tags future_apply
#' @tags globals
#' @tags detritus-files
#' @tags sequential multisession multicore

if (packageVersion("future") > "1.49.0" && isTRUE(getOption("future.globals.keepWhere"))) {

  library(futurize)
  options(future.debug = FALSE)
  
  foo <- function(..., FUN = function(...) list(...)) {
    args <- list(...)
    lapply(1L, FUN = function(x) {
      do.call(FUN, args = c(list(x), args))
    }) |> futurize()
  }
  
  bar <- function(..., fun = function(...) list(...)) {
    lapply(1L, FUN = function(x) fun(x, ...)) |> futurize()
  }
  
  yaa <- function(..., FUN = function(...) list(...)) {
    lapply(1L, FUN = function(x) {
      do.call(FUN, args = c(list(x), ...))
    }) |> futurize()
  }
  
  for (strategy in supportedStrategies()) {
    message(sprintf("- plan('%s') ...", strategy))
    plan(strategy)
  
    x1 <- foo()
    y1 <- bar()
    stopifnot(identical(y1, x1))
    z1 <- yaa()
    stopifnot(identical(z1, x1))
  
    x2 <- foo(a = 2)
    y2 <- bar(a = 2)
    z2 <- yaa(a = 2)
    stopifnot(identical(y2, x2))
    stopifnot(identical(z2, x2))
    
    message(sprintf("- plan('%s') ... done", strategy))
  }

} ## if (packageVersion("future") > ...)
