## ----eval=FALSE---------------------------------------------------------------
# library(link2GI)
# 
# otb <- link2GI::linkOTB(searchLocation = "~/apps/otb911/")
# 
# cmd <- link2GI::otb_build_cmd(
# "DimensionalityReduction",
# otb,
# include_optional = "defaults",
# require_output   = TRUE
# )
# 
# cmd[["in"]]     <- "in.tif"
# cmd[["method"]] <- "pca"
# cmd[["nbcomp"]] <- "3"
# 
# cmd <- link2GI::otb_set_out(cmd, otb, key = "out", path = "out.tif")
# str(cmd)

## ----eval=FALSE---------------------------------------------------------------
# # OTB build (for OTB 9.1.1 this is `nbcomp`).
# 
# 
# library(link2GI)
# library(terra)
# 
# # 0) Link OTB
# 
# otb <- link2GI::linkOTB(searchLocation="~/apps/otb911/")
# 
# # 1) Choose algorithm
# 
# algo <- "DimensionalityReduction"
# 
# # 2) Read the OTB help text (source of truth)
# 
# caps <- link2GI::otb_capabilities(algo = algo, gili = otb, include_param_help = FALSE)
# cat(paste(head(caps$text, 60), collapse = "\n"), "\n")
# 
# # 3) Parsed parameter table
# 
# spec <- link2GI::otb_args_spec(algo, otb)
# print(spec[, c("key", "class", "mandatory", "default")], row.names = FALSE)
# 
# # 4) Build a template containing only valid keys (mandatory + defaults)
# 
# cmd <- link2GI::otb_build_cmd(
# algo,
# otb,
# include_optional = "defaults",
# require_output   = TRUE
# )
# 
# # 5) Identify component-count key by inspecting the spec table (no heuristics)
# 
# pca_related <- spec[grepl("^method\.pca\.|^nbcomp$|outdim|comp", spec$key), ]
# print(pca_related[, c("key", "mandatory", "default", "desc")], row.names = FALSE)
# 
# # 6) Set PCA method + number of components (OTB 9.1.1: nbcomp)
# 
# cmd[["method"]] <- "pca"
# cmd[["nbcomp"]] <- "3"
# 
# # 7) Input + output (explicit on-disk paths)
# 
# infile  <- system.file("ex/elev.tif", package = "terra")
# out_dir <- file.path(tempdir(), "link2gi_otb_vignette")
# dir.create(out_dir, recursive = TRUE, showWarnings = FALSE)
# 
# cmd[["in"]]  <- infile
# cmd[["out"]] <- file.path(out_dir, "pca.tif")
# 
# # Show the exact CLI that would be executed
# 
# cat(link2GI::runOTB(cmd, otb, retCommand = TRUE), "\n")
# 
# # Run (writes to disk)
# 
# res <- link2GI::runOTB(cmd, otb, quiet = FALSE)
# 
# # Verify output exists
# 
# file.exists(cmd[["out"]])

## ----eval=FALSE---------------------------------------------------------------
# library(link2GI)
# 
# otb <- link2GI::linkOTB()
# 
# algo <- "EdgeExtraction"
# cmd  <- link2GI::parseOTBFunction(algo = algo, gili = otb)
# 
# # inspect keys (legacy API may expose app-specific names)
# 
# names(cmd)
# 
# # then set required parameters according to the returned structure:
# 
# # cmd[["<input_key>"]]  <- "in.tif"
# 
# # cmd[["<output_key>"]] <- "out.tif"
# 
# # cmd[["<other_key>"]]  <- "value"
# 
# # finally execute
# 
# # link2GI::runOTB(cmd, gili = otb, quiet = FALSE)

