/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.branching;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.AbstractLargeIntBranchingStrategy;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.propagation.listener.PropagationEngineListener;
import choco.kernel.solver.search.IntBranchingDecision;
import choco.kernel.solver.search.ValIterator;
import choco.kernel.solver.search.ValSelector;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DomOverWDegBranching
extends AbstractLargeIntBranchingStrategy
implements PropagationEngineListener {
    protected static final int ABSTRACTCONTRAINT_EXTENSION = AbstractSConstraint.getAbstractSConstraintExtensionNumber("choco.cp.cpsolver.search.integer.varselector.DomOverWDeg");
    protected static final int ABSTRACTVAR_EXTENSION = AbstractVar.getAbstractVarExtensionNumber("choco.cp.cpsolver.search.integer.varselector.DomOverWDeg");
    private IntVar[] _vars;
    private ValIterator _valIterator;
    private ValSelector _valSelector;
    private Solver _solver;
    protected Random randomBreakTies;
    private AbstractSConstraint reuseCstr;
    IntDomainVar v;

    public DomOverWDegBranching(Solver s, ValIterator valHeuri, IntVar[] vars) {
        this._solver = s;
        DisposableIterator<SConstraint> iter = s.getConstraintIterator();
        while (iter.hasNext()) {
            AbstractSConstraint c = (AbstractSConstraint)iter.next();
            c.addExtension(ABSTRACTCONTRAINT_EXTENSION);
        }
        iter.dispose();
        for (int i = 0; i < s.getNbIntVars(); ++i) {
            IntDomainVar v = s.getIntVar(i);
            v.addExtension(ABSTRACTVAR_EXTENSION);
        }
        for (int val : s.getIntConstantSet()) {
            Var v = s.getIntConstant(val);
            v.addExtension(ABSTRACTVAR_EXTENSION);
        }
        s.getPropagationEngine().addPropagationEngineListener(this);
        this._valIterator = valHeuri;
        this._vars = vars;
    }

    @Override
    public void safeDelete() {
        this._solver.getPropagationEngine().removePropagationEngineListener(this);
    }

    public DomOverWDegBranching(Solver s, ValIterator valHeuri) {
        this(s, valHeuri, DomOverWDegBranching.buildVars(s));
    }

    public DomOverWDegBranching(Solver s, ValSelector valHeuri, IntVar[] vars) {
        this._solver = s;
        DisposableIterator<SConstraint> iter = s.getConstraintIterator();
        while (iter.hasNext()) {
            AbstractSConstraint c = (AbstractSConstraint)iter.next();
            c.addExtension(ABSTRACTCONTRAINT_EXTENSION);
        }
        iter.dispose();
        for (int i = 0; i < s.getNbIntVars(); ++i) {
            IntDomainVar v = s.getIntVar(i);
            v.addExtension(ABSTRACTVAR_EXTENSION);
        }
        for (int val : s.getIntConstantSet()) {
            Var v = s.getIntConstant(val);
            v.addExtension(ABSTRACTVAR_EXTENSION);
        }
        s.getPropagationEngine().addPropagationEngineListener(this);
        this._valSelector = valHeuri;
        this._vars = vars;
    }

    public DomOverWDegBranching(Solver s, ValSelector valHeuri) {
        this(s, valHeuri, DomOverWDegBranching.buildVars(s));
    }

    private static IntVar[] buildVars(Solver s) {
        IntVar[] vars = new IntVar[s.getNbIntVars()];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = s.getIntVar(i);
        }
        return vars;
    }

    @Override
    public void initBranching() {
        for (IntVar v : this._vars) {
            int weight = 0;
            DisposableIntIterator c = v.getIndexVector().getIndexIterator();
            int idx = 0;
            while (c.hasNext()) {
                idx = c.next();
                AbstractSConstraint cstr = (AbstractSConstraint)v.getConstraint(idx);
                if (cstr.getNbVarNotInst() <= 1) continue;
                weight += cstr.getExtension(ABSTRACTCONTRAINT_EXTENSION).get() + cstr.getFineDegree(v.getVarIndex(idx));
            }
            c.dispose();
            v.getExtension(ABSTRACTVAR_EXTENSION).set(weight);
        }
    }

    @Override
    public void initConstraintForBranching(SConstraint c) {
        c.addExtension(ABSTRACTCONTRAINT_EXTENSION);
    }

    public void setBranchingVars(IntVar[] vs) {
        this._vars = vs;
    }

    public void setRandomVarTies(int seed) {
        this.randomBreakTies = new Random(seed);
    }

    @Override
    public Object selectBranchingObject() throws ContradictionException {
        int previous_Size = -1;
        int previous_Weight = -1;
        IntDomainVar previous_Variable = null;
        if (this.randomBreakTies == null) {
            for (int i = 0; i < this._vars.length; ++i) {
                IntDomainVar var = (IntDomainVar)this._vars[i];
                if (var.isInstantiated()) continue;
                if (previous_Variable == null) {
                    previous_Variable = var;
                    previous_Size = var.getDomainSize();
                    previous_Weight = var.getExtension(ABSTRACTVAR_EXTENSION).get();
                    continue;
                }
                if (var.getExtension(ABSTRACTVAR_EXTENSION).get() * previous_Size - previous_Weight * var.getDomainSize() <= 0) continue;
                previous_Variable = var;
                previous_Size = var.getDomainSize();
                previous_Weight = var.getExtension(ABSTRACTVAR_EXTENSION).get();
            }
            return previous_Variable;
        }
        LinkedList<IntDomainVar> lvs = new LinkedList<IntDomainVar>();
        for (int i = 0; i < this._vars.length; ++i) {
            IntDomainVar var = (IntDomainVar)this._vars[i];
            if (var.isInstantiated()) continue;
            if (previous_Variable == null) {
                previous_Variable = var;
                previous_Size = var.getDomainSize();
                previous_Weight = var.getExtension(ABSTRACTVAR_EXTENSION).get();
                lvs.add(var);
                continue;
            }
            int note = var.getExtension(ABSTRACTVAR_EXTENSION).get() * previous_Size - previous_Weight * var.getDomainSize();
            if (note > 0) {
                lvs.clear();
                lvs.add(var);
                previous_Size = var.getDomainSize();
                previous_Weight = var.getExtension(ABSTRACTVAR_EXTENSION).get();
                continue;
            }
            if (note < 0) continue;
            lvs.add(var);
        }
        if (lvs.isEmpty()) {
            return null;
        }
        return lvs.get(this.randomBreakTies.nextInt(lvs.size()));
    }

    @Override
    public void setFirstBranch(IntBranchingDecision decision) {
        this.v = decision.getBranchingIntVar();
        DisposableIterator<SConstraint> iter = this.v.getConstraintsIterator();
        while (iter.hasNext()) {
            this.reuseCstr = (AbstractSConstraint)iter.next();
            if (!SConstraintType.INTEGER.equals((Object)this.reuseCstr.getConstraintType()) || this.reuseCstr.getNbVarNotInst() != 2) continue;
            for (int k = 0; k < this.reuseCstr.getNbVars(); ++k) {
                AbstractVar var = (AbstractVar)((AbstractIntSConstraint)this.reuseCstr).getVar(k);
                if (var == this.v || var.isInstantiated()) continue;
                var.getExtension(ABSTRACTVAR_EXTENSION).add(-this.reuseCstr.getExtension(ABSTRACTCONTRAINT_EXTENSION).get());
            }
        }
        iter.dispose();
        if (this._valIterator != null) {
            decision.setBranchingValue(this._valIterator.getFirstVal(this.v));
        } else {
            decision.setBranchingValue(this._valSelector.getBestVal(this.v));
        }
    }

    @Override
    public void setNextBranch(IntBranchingDecision decision) {
        if (this._valIterator != null) {
            decision.setBranchingValue(this._valIterator.getNextVal(decision.getBranchingIntVar(), decision.getBranchingValue()));
        } else {
            decision.setBranchingValue(this._valSelector.getBestVal(decision.getBranchingIntVar()));
        }
    }

    @Override
    public boolean finishedBranching(IntBranchingDecision decision) {
        if (this._valIterator != null) {
            boolean finished;
            this.v = decision.getBranchingIntVar();
            boolean bl = finished = !this._valIterator.hasNextVal(this.v, decision.getBranchingValue());
            if (finished) {
                DisposableIterator<SConstraint> iter = this.v.getConstraintsIterator();
                while (iter.hasNext()) {
                    this.reuseCstr = (AbstractSConstraint)iter.next();
                    if (!SConstraintType.INTEGER.equals((Object)this.reuseCstr.getConstraintType()) || this.reuseCstr.getNbVarNotInst() != 2) continue;
                    for (int k = 0; k < this.reuseCstr.getNbVars(); ++k) {
                        AbstractVar var = (AbstractVar)((AbstractIntSConstraint)this.reuseCstr).getVar(k);
                        if (var == this.v || var.isInstantiated()) continue;
                        var.getExtension(ABSTRACTVAR_EXTENSION).add(this.reuseCstr.getExtension(ABSTRACTCONTRAINT_EXTENSION).get());
                    }
                }
                iter.dispose();
            }
            return finished;
        }
        return false;
    }

    @Override
    public void goDownBranch(IntBranchingDecision decision) throws ContradictionException {
        decision.setIntVal();
    }

    @Override
    public void goUpBranch(IntBranchingDecision decision) throws ContradictionException {
    }

    @Override
    public String getDecisionLogMessage(IntBranchingDecision decision) {
        return decision.getBranchingObject() + "==" + decision.getBranchingValue();
    }

    @Override
    public void contradictionOccured(ContradictionException e) {
        SConstraint cause = e.getDomOverDegContradictionCause();
        if (cause != null) {
            this.reuseCstr = (AbstractSConstraint)cause;
            if (SConstraintType.INTEGER.equals((Object)this.reuseCstr.getConstraintType())) {
                try {
                    this.reuseCstr.getExtension(ABSTRACTCONTRAINT_EXTENSION).add(1);
                }
                catch (NullPointerException npe) {
                    this.reuseCstr.addExtension(ABSTRACTCONTRAINT_EXTENSION);
                    this.reuseCstr.getExtension(ABSTRACTCONTRAINT_EXTENSION).add(1);
                }
                for (int k = 0; k < this.reuseCstr.getNbVars(); ++k) {
                    AbstractVar var = (AbstractVar)((AbstractIntSConstraint)this.reuseCstr).getVar(k);
                    var.getExtension(ABSTRACTVAR_EXTENSION).add(1);
                }
            }
        }
    }

    protected static void appendConstraint(StringBuilder b, SConstraint c) {
        AbstractSConstraint cstr = (AbstractSConstraint)c;
        b.append("w=").append(cstr.getExtension(ABSTRACTCONTRAINT_EXTENSION).get());
        b.append('\t').append(cstr.pretty());
        b.append('\n');
    }

    protected static void appendVariable(StringBuilder b, Var v) {
        AbstractVar var = (AbstractVar)v;
        b.append("w=").append(var.getExtension(ABSTRACTVAR_EXTENSION).get());
        b.append('\t').append(var.pretty());
        b.append('\n');
    }

    public final void logWeights(Logger logger, Level level) {
        if (logger.isLoggable(level)) {
            StringBuilder b = new StringBuilder(20);
            b.append("===> Display DomWDeg weights\n");
            b.append("\n###\tConstraints\t###\n");
            DisposableIterator<SConstraint> iter = this._solver.getConstraintIterator();
            while (iter.hasNext()) {
                DomOverWDegBranching.appendConstraint(b, (SConstraint)iter.next());
            }
            iter.dispose();
            b.append("\n###\tVariables\t###\n");
            for (int i = 0; i < this._solver.getNbIntVars(); ++i) {
                DomOverWDegBranching.appendVariable(b, this._solver.getIntVar(i));
            }
            b.append("\n###\tConstants\t###\n");
            Iterator<Integer> it = this._solver.getIntConstantSet().iterator();
            while (it.hasNext()) {
                DomOverWDegBranching.appendVariable(b, this._solver.getIntConstant(it.next()));
            }
            b.append("<=== End Display DomWDeg weights\n");
            logger.log(level, new String(b));
        }
    }
}

