/**
 * @file core/tree/bounds.hpp
 *
 * Bounds that are useful for binary space partitioning trees.
 *
 * mlpack is free software; you may redistribute it and/or modify it under the
 * terms of the 3-clause BSD license.  You should have received a copy of the
 * 3-clause BSD license along with mlpack.  If not, see
 * http://www.opensource.org/licenses/BSD-3-Clause for more information.
 */

#ifndef MLPACK_CORE_TREE_BOUNDS_HPP
#define MLPACK_CORE_TREE_BOUNDS_HPP

#include <mlpack/core/math/range.hpp>
#include <mlpack/core/distances/lmetric.hpp>

#include "bound_traits.hpp"
#include "hrectbound.hpp"
#include "ballbound.hpp"
#include "hollow_ball_bound.hpp"
#include "cellbound.hpp"

#endif // MLPACK_CORE_TREE_BOUNDS_HPP
