/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.sort;

import com.qarks.util.ui.sort.Arrow;
import com.qarks.util.ui.sort.SortDirective;
import com.qarks.util.ui.sort.TableSorterListener;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected TableModel tableModel;
    private static SortDirective EMPTY_DIRECTIVE = new SortDirective(-1, 0);
    public static final Comparator COMPARABLE_COMAPRATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }
    };
    private Row[] viewToModel;
    private int[] modelToView;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    private Map columnComparators = new HashMap();
    private List sortingColumns = new ArrayList();
    private Vector<TableSorterListener> tableSorterListener;

    public TableSorter() {
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
        this.tableSorterListener = new Vector();
    }

    public TableSorter(TableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    public TableSorter(TableModel tableModel, JTableHeader jTableHeader) {
        this();
        this.setTableHeader(jTableHeader);
        this.setTableModel(tableModel);
    }

    private void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer tableCellRenderer = this.tableHeader.getDefaultRenderer();
            if (tableCellRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)tableCellRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = jTableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    private SortDirective getDirective(int n) {
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            SortDirective sortDirective = (SortDirective)this.sortingColumns.get(i);
            if (sortDirective.getColumnIndex() != n) continue;
            return sortDirective;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getSortingStatus(int n) {
        return this.getDirective(n).getDirection();
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    public void setSortingStatus(int n, int n2) {
        SortDirective sortDirective = this.getDirective(n);
        if (sortDirective != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(sortDirective);
        }
        if (n2 != 0) {
            this.sortingColumns.add(new SortDirective(n, n2));
        }
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int n, int n2) {
        SortDirective sortDirective = this.getDirective(n);
        if (sortDirective == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(sortDirective.getDirection() == -1, n2, this.sortingColumns.indexOf(sortDirective));
    }

    private void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class clazz, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(clazz);
        } else {
            this.columnComparators.put(clazz, comparator);
        }
    }

    protected Comparator getComparator(int n) {
        Class<?> clazz = this.tableModel.getColumnClass(n);
        Comparator comparator = (Comparator)this.columnComparators.get(clazz);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return COMPARABLE_COMAPRATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    private Row[] getViewToModel() {
        if (this.viewToModel == null) {
            int n = this.tableModel.getRowCount();
            this.viewToModel = new Row[n];
            for (int i = 0; i < n; ++i) {
                this.viewToModel[i] = new Row(i);
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    public int modelIndex(int n) {
        return this.getViewToModel()[n].modelIndex;
    }

    private int[] getModelToView() {
        if (this.modelToView == null) {
            int n = this.getViewToModel().length;
            this.modelToView = new int[n];
            for (int i = 0; i < n; ++i) {
                this.modelToView[this.modelIndex((int)i)] = i;
            }
        }
        return this.modelToView;
    }

    @Override
    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.tableModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.tableModel.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.tableModel.isCellEditable(this.modelIndex(n), n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.tableModel.getValueAt(this.modelIndex(n), n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.tableModel.setValueAt(object, this.modelIndex(n), n2);
    }

    public void addListener(TableSorterListener tableSorterListener) {
        this.tableSorterListener.add(tableSorterListener);
    }

    public void removeListener(TableSorterListener tableSorterListener) {
        this.tableSorterListener.remove(tableSorterListener);
    }

    public void notifyListener(int n, String string) {
        for (TableSorterListener tableSorterListener : this.tableSorterListener) {
            tableSorterListener.changeSorterColumn(n, string);
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalTextPosition(2);
                if (TableSorter.this.tableModel.getColumnCount() == 1) {
                    TableColumn tableColumn = jTable.getColumnModel().getColumn(n2);
                    String string = (String)tableColumn.getIdentifier();
                    jLabel.setText(string);
                    jLabel.setIcon(TableSorter.this.getHeaderRendererIcon(n2, jLabel.getFont().getSize()));
                } else {
                    int n3 = jTable.convertColumnIndexToModel(n2);
                    jLabel.setIcon(TableSorter.this.getHeaderRendererIcon(n3, jLabel.getFont().getSize()));
                }
            }
            return component;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            if (TableSorter.this.tableModel.getColumnCount() == 1) {
                if (n != -1) {
                    int n2 = TableSorter.this.getSortingStatus(n);
                    if (!mouseEvent.isControlDown()) {
                        TableSorter.this.cancelSorting();
                    }
                    n2 += mouseEvent.isShiftDown() ? -1 : 1;
                    n2 = (n2 + 4) % 3 - 1;
                    TableSorter.this.setSortingStatus(n, n2);
                    String string = (String)tableColumnModel.getColumn(n).getIdentifier();
                    TableSorter.this.notifyListener(n2, string);
                }
            } else {
                int n3 = tableColumnModel.getColumn(n).getModelIndex();
                if (n3 != -1) {
                    int n4 = TableSorter.this.getSortingStatus(n3);
                    if (!mouseEvent.isControlDown()) {
                        TableSorter.this.cancelSorting();
                    }
                    n4 += mouseEvent.isShiftDown() ? -1 : 1;
                    n4 = (n4 + 4) % 3 - 1;
                    TableSorter.this.setSortingStatus(n3, n4);
                }
            }
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (!TableSorter.this.isSorting()) {
                TableSorter.this.clearSortingState();
                TableSorter.this.fireTableChanged(tableModelEvent);
                return;
            }
            if (tableModelEvent.getFirstRow() == -1) {
                TableSorter.this.cancelSorting();
                TableSorter.this.fireTableChanged(tableModelEvent);
                return;
            }
            int n = tableModelEvent.getColumn();
            if (tableModelEvent.getFirstRow() == tableModelEvent.getLastRow() && n != -1 && TableSorter.this.getSortingStatus(n) == 0 && TableSorter.this.modelToView != null) {
                int n2 = TableSorter.this.getModelToView()[tableModelEvent.getFirstRow()];
                TableSorter.this.fireTableChanged(new TableModelEvent(TableSorter.this, n2, n2, n, tableModelEvent.getType()));
                return;
            }
            TableSorter.this.clearSortingState();
            TableSorter.this.fireTableDataChanged();
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int n) {
            this.modelIndex = n;
        }

        public int compareTo(Object object) {
            int n = this.modelIndex;
            int n2 = ((Row)object).modelIndex;
            for (SortDirective sortDirective : TableSorter.this.sortingColumns) {
                int n3 = sortDirective.getColumnIndex();
                Object object2 = TableSorter.this.tableModel.getValueAt(n, n3);
                Object object3 = TableSorter.this.tableModel.getValueAt(n2, n3);
                int n4 = 0;
                n4 = object2 == null && object3 == null ? 0 : (object2 == null ? -1 : (object3 == null ? 1 : TableSorter.this.getComparator(n3).compare(object2, object3)));
                if (n4 == 0) continue;
                return sortDirective.getDirection() == -1 ? -n4 : n4;
            }
            return 0;
        }
    }
}

