/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.lookandfeel;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;

public class ExtendedTableUI
extends BasicTableUI {
    private PropertyChangeDelegate delegate = null;
    private MouseHandler handler = null;

    public ExtendedTableUI(JTable jTable) {
        this.table = jTable;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (jComponent instanceof JTable) {
            return new ExtendedTableUI((JTable)jComponent);
        }
        return ExtendedTableUI.createUI(jComponent);
    }

    @Override
    protected void installListeners() {
        int n;
        super.installListeners();
        MouseListener[] mouseListenerArray = this.table.getMouseListeners();
        MouseMotionListener[] mouseMotionListenerArray = this.table.getMouseMotionListeners();
        for (n = 0; n < mouseListenerArray.length; ++n) {
            if (!mouseListenerArray[n].getClass().getPackage().getName().startsWith("javax.swing.plaf")) continue;
            this.table.removeMouseListener(mouseListenerArray[n]);
        }
        for (n = 0; n < mouseMotionListenerArray.length; ++n) {
            if (!mouseMotionListenerArray[n].getClass().getPackage().getName().startsWith("javax.swing.plaf")) continue;
            this.table.removeMouseMotionListener(mouseMotionListenerArray[n]);
        }
        this.handler = new MouseHandler();
        this.table.addMouseListener(this.handler);
        this.table.addMouseMotionListener(this.handler);
        this.table.setDropTarget(new SimpleDropTarget());
        PropertyChangeListener[] propertyChangeListenerArray = this.table.getPropertyChangeListeners();
        boolean bl = false;
        for (int i = 0; i < propertyChangeListenerArray.length && !bl; ++i) {
            bl = propertyChangeListenerArray[i].getClass().getPackage().getName().startsWith("javax.swing.plaf");
            if (!bl) continue;
            PropertyChangeListener propertyChangeListener = propertyChangeListenerArray[i];
            this.table.removePropertyChangeListener(propertyChangeListener);
            this.delegate = new PropertyChangeDelegate(propertyChangeListener);
            this.table.addPropertyChangeListener(this.delegate);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.table.removePropertyChangeListener(this.delegate);
        this.table.removeMouseListener(this.handler);
        this.table.removeMouseMotionListener(this.handler);
    }

    protected class MouseHandler
    implements MouseInputListener {
        private int indexOnPress = -1;
        private MouseEvent dndArmedEvent = null;
        private int motionThreshold;
        private boolean checkedMotionThreshold = false;
        private Component dispatchComponent;

        protected MouseHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.shouldIgnore2(mouseEvent)) {
                return;
            }
            if (this.dndArmedEvent != null) {
                int n = this.mapDragOperationFromModifiers(mouseEvent);
                if (n == 0) {
                    return;
                }
                int n2 = Math.abs(mouseEvent.getX() - this.dndArmedEvent.getX());
                int n3 = Math.abs(mouseEvent.getY() - this.dndArmedEvent.getY());
                if (n2 > this.getMotionThreshold() || n3 > this.getMotionThreshold()) {
                    JComponent jComponent = this.getComponent(mouseEvent);
                    TransferHandler transferHandler = jComponent.getTransferHandler();
                    transferHandler.exportAsDrag(jComponent, this.dndArmedEvent, n);
                    this.dndArmedEvent = null;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            block12: {
                block13: {
                    if (this.shouldIgnore(mouseEvent)) {
                        return;
                    }
                    Point point = mouseEvent.getPoint();
                    int n = ExtendedTableUI.this.table.rowAtPoint(point);
                    int n2 = ExtendedTableUI.this.table.columnAtPoint(point);
                    if (n2 == -1 || n == -1) {
                        return;
                    }
                    if (ExtendedTableUI.this.table.editCellAt(n, n2, mouseEvent)) {
                        this.setDispatchComponent(mouseEvent);
                        this.repostEvent(mouseEvent);
                    } else if (ExtendedTableUI.this.table.isRequestFocusEnabled()) {
                        ExtendedTableUI.this.table.requestFocus();
                    }
                    TableCellEditor tableCellEditor = ExtendedTableUI.this.table.getCellEditor();
                    if (tableCellEditor != null && !tableCellEditor.shouldSelectCell(mouseEvent)) break block12;
                    this.indexOnPress = ExtendedTableUI.this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    if (this.indexOnPress <= -1) break block13;
                    this.dndArmedEvent = mouseEvent;
                    switch (ExtendedTableUI.this.table.getSelectionModel().getSelectionMode()) {
                        case 0: {
                            ExtendedTableUI.this.table.setRowSelectionInterval(this.indexOnPress, this.indexOnPress);
                            break;
                        }
                        default: {
                            if (!mouseEvent.isControlDown()) {
                                if (mouseEvent.isShiftDown()) {
                                    int n3 = ExtendedTableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
                                    ExtendedTableUI.this.table.getSelectionModel().clearSelection();
                                    if (this.indexOnPress > n3) {
                                        ExtendedTableUI.this.table.getSelectionModel().addSelectionInterval(n3, this.indexOnPress);
                                        break;
                                    }
                                    ExtendedTableUI.this.table.getSelectionModel().addSelectionInterval(this.indexOnPress, n3);
                                    break;
                                }
                                if (!ExtendedTableUI.this.table.isRowSelected(this.indexOnPress)) {
                                    ExtendedTableUI.this.table.setRowSelectionInterval(this.indexOnPress, this.indexOnPress);
                                    break;
                                } else {
                                    break;
                                }
                            } else {
                                break;
                            }
                        }
                    }
                    break block12;
                }
                this.dndArmedEvent = null;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isShiftDown()) {
                return;
            }
            int n = ExtendedTableUI.this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            if (mouseEvent.isControlDown()) {
                switch (ExtendedTableUI.this.table.getSelectionModel().getSelectionMode()) {
                    case 1: {
                        int n2 = ExtendedTableUI.this.table.getSelectionModel().getMinSelectionIndex();
                        int n3 = ExtendedTableUI.this.table.getSelectionModel().getMaxSelectionIndex();
                        if (ExtendedTableUI.this.table.isRowSelected(n)) {
                            if (n != n2 && n != n3) break;
                            ExtendedTableUI.this.table.getSelectionModel().addSelectionInterval(n, n);
                            break;
                        }
                        if (n != n2 - 1 && n != n3 + 1) break;
                        ExtendedTableUI.this.table.getSelectionModel().addSelectionInterval(n, n);
                        break;
                    }
                    case 2: {
                        if (ExtendedTableUI.this.table.isRowSelected(n)) {
                            ExtendedTableUI.this.table.getSelectionModel().removeSelectionInterval(n, n);
                            break;
                        }
                        ExtendedTableUI.this.table.getSelectionModel().addSelectionInterval(n, n);
                    }
                }
            } else if (ExtendedTableUI.this.table.isRowSelected(n) && !SwingUtilities.isRightMouseButton(mouseEvent)) {
                ExtendedTableUI.this.table.setRowSelectionInterval(n, n);
            }
        }

        private int getMotionThreshold() {
            if (this.checkedMotionThreshold) {
                return this.motionThreshold;
            }
            this.checkedMotionThreshold = true;
            try {
                this.motionThreshold = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
            }
            catch (Exception exception) {
                this.motionThreshold = 5;
            }
            return this.motionThreshold;
        }

        protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                JComponent jComponent = this.getComponent(mouseEvent);
                TransferHandler transferHandler = jComponent.getTransferHandler();
                return transferHandler.getSourceActions(jComponent);
            }
            return 0;
        }

        protected JComponent getComponent(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                return jComponent;
            }
            return null;
        }

        private void setDispatchComponent(MouseEvent mouseEvent) {
            Component component = ExtendedTableUI.this.table.getEditorComponent();
            Point point = mouseEvent.getPoint();
            Point point2 = SwingUtilities.convertPoint(ExtendedTableUI.this.table, point, component);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
        }

        private boolean repostEvent(MouseEvent mouseEvent) {
            if (this.dispatchComponent == null || !ExtendedTableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(ExtendedTableUI.this.table, mouseEvent, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(mouseEvent2);
            return true;
        }

        private boolean shouldIgnore(MouseEvent mouseEvent) {
            return mouseEvent.isConsumed() || !ExtendedTableUI.this.table.isEnabled();
        }

        private boolean shouldIgnore2(MouseEvent mouseEvent) {
            return mouseEvent.isConsumed() || !ExtendedTableUI.this.table.getDragEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent) || !ExtendedTableUI.this.table.isEnabled();
        }
    }

    public class SimpleDropTarget
    extends DropTarget
    implements UIResource {
        @Override
        public synchronized void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    public class PropertyChangeDelegate
    implements PropertyChangeListener {
        private PropertyChangeListener delegate;

        public PropertyChangeDelegate(PropertyChangeListener propertyChangeListener) {
            this.delegate = propertyChangeListener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("transferHandler".equals(string)) {
                DropTarget dropTarget = ExtendedTableUI.this.table.getDropTarget();
                if (dropTarget instanceof UIResource) {
                    try {
                        dropTarget.addDropTargetListener(new SimpleDropTarget());
                    }
                    catch (TooManyListenersException tooManyListenersException) {}
                }
            } else {
                this.delegate.propertyChange(propertyChangeEvent);
            }
        }
    }
}

