/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.optimization.cmaes;

import java.io.Serializable;
import java.util.Properties;

public class CMAOptions
implements Serializable {
    private static final long serialVersionUID = 2255162105325585121L;
    public long diagonalCovarianceMatrix = 0L;
    public double[] lowerStandardDeviations;
    public double[] upperStandardDeviations;
    public double stopFitness = Double.MIN_VALUE;
    public double stopTolFun = 1.0E-12;
    public double stopTolFunHist = 1.0E-13;
    public double stopTolX = 0.0;
    public double stopTolXFactor = 1.0E-11;
    public double stopTolUpXFactor = 1000.0;
    public long stopMaxFunEvals = Long.MAX_VALUE;
    public long stopMaxIter = Long.MAX_VALUE;
    public boolean stopnow = false;
    public int verbosity = 1;
    public String outputFileNamesPrefix = "outcmaes";
    public int writeDisplayToFile = 1;
    public double maxTimeFractionForEigendecomposition = 0.2;
    public double maxTimeFractionForWriteToDefaultFiles = 0.1;
    public int checkEigenSystem = 0;

    void setOptions(Properties properties) {
        this.diagonalCovarianceMatrix = this.getFirstToken(properties.getProperty("diagonalCovarianceMatrix"), this.diagonalCovarianceMatrix);
        String s = properties.getProperty("stopFitness");
        if (s != null) {
            this.stopFitness = Double.valueOf(this.getFirstToken(s));
        }
        this.stopTolFun = this.getFirstToken(properties.getProperty("stopTolFun"), this.stopTolFun);
        this.stopTolFunHist = this.getFirstToken(properties.getProperty("stopTolFunHist"), this.stopTolFunHist);
        this.stopTolX = this.getFirstToken(properties.getProperty("stopTolX"), this.stopTolX);
        this.stopTolXFactor = this.getFirstToken(properties.getProperty("stopTolXFactor"), this.stopTolXFactor);
        this.stopTolUpXFactor = this.getFirstToken(properties.getProperty("stopTolUpXFactor"), this.stopTolUpXFactor);
        this.stopMaxFunEvals = this.getFirstToken(properties.getProperty("stopMaxFunEvals"), this.stopMaxFunEvals);
        this.stopMaxIter = this.getFirstToken(properties.getProperty("stopMaxIter"), this.stopMaxIter);
        s = properties.getProperty("upperStandardDeviations");
        if (s != null && !s.equals("")) {
            this.upperStandardDeviations = this.parseDouble(this.getAllToken(s));
        }
        if ((s = properties.getProperty("lowerStandardDeviations")) != null && !s.equals("")) {
            this.lowerStandardDeviations = this.parseDouble(this.getAllToken(s));
        }
        this.outputFileNamesPrefix = properties.getProperty("outputFileNamesPrefix", this.outputFileNamesPrefix).split("\\s")[0];
        this.maxTimeFractionForEigendecomposition = this.getFirstToken(properties.getProperty("maxTimeFractionForEigendecomposition"), this.maxTimeFractionForEigendecomposition);
        this.maxTimeFractionForWriteToDefaultFiles = this.getFirstToken(properties.getProperty("maxTimeFractionForWriteToDefaultFiles"), this.maxTimeFractionForWriteToDefaultFiles);
        this.stopnow = "now".equals(this.getFirstToken(properties.getProperty("stop")));
        this.writeDisplayToFile = this.getFirstToken(properties.getProperty("writeDisplayToFile"), this.writeDisplayToFile);
        this.checkEigenSystem = this.getFirstToken(properties.getProperty("checkEigenSystem"), this.checkEigenSystem);
    }

    public Double getFirstToken(String s, Double def) {
        if (s == null) {
            return def;
        }
        String[] ar = s.split("\\s+");
        if (ar[0].equals("")) {
            return def;
        }
        return Double.valueOf(ar[0]);
    }

    public String getFirstToken(String s) {
        if (s == null) {
            return "";
        }
        String[] ar = s.split(new String("\\s+"));
        return ar[0];
    }

    public Integer getFirstToken(String s, Integer def) {
        if (s == null) {
            return def;
        }
        String[] ar = s.split("\\s+");
        if (ar[0].equals("")) {
            return def;
        }
        return Integer.valueOf(ar[0]);
    }

    private String removeComments(String s) {
        int i = s.indexOf("#");
        if (i >= 0) {
            s = s.substring(0, i);
        }
        if ((i = s.indexOf("!")) >= 0) {
            s = s.substring(0, i);
        }
        if ((i = s.indexOf("%")) >= 0) {
            s = s.substring(0, i);
        }
        if ((i = s.indexOf("//")) >= 0) {
            s = s.substring(0, i);
        }
        return s;
    }

    private Long getFirstToken(String s, Long def) {
        if (s == null) {
            return def;
        }
        String[] ar = this.removeComments(s).split("\\s+");
        if (ar[0].equals("")) {
            return def;
        }
        return Long.valueOf(ar[0]);
    }

    String[] getAllToken(String s) {
        return this.removeComments(s).split("\\s+");
    }

    double[] parseDouble(String[] ars) {
        double[] ard = new double[ars.length];
        int i = 0;
        while (i < ars.length) {
            ard[i] = Double.parseDouble(ars[i]);
            ++i;
        }
        return ard;
    }
}

