/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fragment.MurckoFragmenter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.DoubleResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class FMFDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    public DescriptorValue calculate(IAtomContainer container) {
        DoubleResult result;
        container = FMFDescriptor.clone((IAtomContainer)container);
        MurckoFragmenter fragmenter = new MurckoFragmenter(true, 3);
        try {
            fragmenter.generateFragments(container);
            IAtomContainer[] framework = fragmenter.getFrameworksAsContainers();
            IAtomContainer[] ringSystems = fragmenter.getRingSystemsAsContainers();
            result = framework.length == 1 ? new DoubleResult((double)framework[0].getAtomCount() / (double)container.getAtomCount()) : (framework.length == 0 && ringSystems.length == 1 ? new DoubleResult((double)ringSystems[0].getAtomCount() / (double)container.getAtomCount()) : new DoubleResult(0.0));
        }
        catch (CDKException e) {
            result = new DoubleResult(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)result, this.getDescriptorNames());
    }

    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResultType();
    }

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#fmf", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public String[] getParameterNames() {
        return null;
    }

    public Object getParameterType(String name) {
        return null;
    }

    public void setParameters(Object[] params) throws CDKException {
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return new String[]{"FMF"};
    }
}

