/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.vecmath.Vector3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.UnsupportedChemObjectException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.CrystClustFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class CrystClustWriter
extends DefaultChemObjectWriter {
    private BufferedWriter writer;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(CrystClustWriter.class);

    public CrystClustWriter(Writer out) {
        try {
            this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        }
        catch (Exception exc) {
            logger.debug((Object)exc.toString());
        }
    }

    public CrystClustWriter(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public CrystClustWriter() {
        this(new StringWriter());
    }

    public IResourceFormat getFormat() {
        return CrystClustFormat.getInstance();
    }

    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (ICrystal.class.equals(anInterface)) {
                return true;
            }
            if (!IChemSequence.class.equals(anInterface)) continue;
            return true;
        }
        return false;
    }

    public void write(IChemObject object) throws UnsupportedChemObjectException {
        if (object instanceof ICrystal) {
            this.writeCrystal((ICrystal)object);
        } else if (object instanceof IChemSequence) {
            this.writeChemSequence((IChemSequence)object);
        } else {
            throw new UnsupportedChemObjectException("This object type is not supported.");
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }

    private void writeChemSequence(IChemSequence cs) throws UnsupportedChemObjectException {
        int count = cs.getChemModelCount();
        for (int i = 0; i < count; ++i) {
            this.writeln("frame: " + (i + 1));
            this.writeCrystal(cs.getChemModel(i).getCrystal());
        }
    }

    private void writeCrystal(ICrystal crystal) {
        String sg = crystal.getSpaceGroup();
        if ("P 2_1 2_1 2_1".equals(sg)) {
            this.writeln("P 21 21 21 (1)");
        } else {
            this.writeln("P 1 (1)");
        }
        this.writeVector3d(crystal.getA());
        this.writeVector3d(crystal.getB());
        this.writeVector3d(crystal.getC());
        int noatoms = crystal.getAtomCount();
        this.write(Integer.toString(noatoms));
        this.writeln("");
        if (!sg.equals("P1")) {
            throw new IllegalStateException("Unknown asymmetric units for SpaceGroup=" + sg);
        }
        this.writeln("1");
        for (int i = 0; i < noatoms; ++i) {
            IAtom atom = crystal.getAtom(i);
            this.write(atom.getSymbol());
            this.write(":");
            this.writeln(Double.toString(atom.getCharge()));
            this.writeln(Double.toString(atom.getPoint3d().x));
            this.writeln(Double.toString(atom.getPoint3d().y));
            this.writeln(Double.toString(atom.getPoint3d().z));
        }
    }

    private void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            System.err.println("CMLWriter IOException while printing \"" + s + "\":" + e);
        }
    }

    private void writeln(String s) {
        try {
            this.writer.write(s);
            this.writer.write(10);
        }
        catch (IOException e) {
            System.err.println("CMLWriter IOException while printing \"" + s + "\":" + e);
        }
    }

    private void writeVector3d(Vector3d vector) {
        this.write(Double.toString(vector.x));
        this.writeln("");
        this.write(Double.toString(vector.y));
        this.writeln("");
        this.write(Double.toString(vector.z));
        this.writeln("");
    }
}

