/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractLattice;
import org.xmlcml.cml.element.CMLLatticeVector;
import org.xmlcml.cml.element.CMLVector3;

public class CMLLattice
extends AbstractLattice {
    public static final String NS = "cml:lattice";

    public CMLLattice() {
    }

    public CMLLattice(CMLLattice old) {
        super(old);
    }

    @Override
    public Element copy() {
        return new CMLLattice(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLLattice();
    }

    public CMLLattice(CMLLatticeVector[] lv) {
        this();
        if (lv == null || lv.length != 3) {
            throw new RuntimeException("Invalid latticeVectors");
        }
        this.addLatticeVectors(lv[0], lv[1], lv[2]);
    }

    public CMLLattice(CMLLatticeVector a, CMLLatticeVector b, CMLLatticeVector c) {
        this();
        this.addLatticeVectors(a, b, c);
    }

    void addLatticeVectors(CMLLatticeVector a, CMLLatticeVector b, CMLLatticeVector c) {
        if (a == null) {
            throw new RuntimeException("Null latticeVector");
        }
        this.appendChild((Node)a);
        if (b == null) {
            throw new RuntimeException("Null latticeVector");
        }
        this.appendChild((Node)b);
        if (c == null) {
            throw new RuntimeException("Null latticeVector");
        }
        this.appendChild((Node)c);
    }

    public double[] getCellParameters() {
        CMLVector3 a = this.getLatticeVectorElements().get(0).getCMLVector3();
        CMLVector3 b = this.getLatticeVectorElements().get(1).getCMLVector3();
        CMLVector3 c = this.getLatticeVectorElements().get(2).getCMLVector3();
        double[] params = new double[]{a.getLength(), b.getLength(), c.getLength(), b.getAngleMadeWith(c).getDegrees(), c.getAngleMadeWith(a).getDegrees(), a.getAngleMadeWith(b).getDegrees()};
        return params;
    }

    public CMLVector3 getCMLVector3(int i) {
        CMLElements<CMLLatticeVector> abc = this.getLatticeVectorElements();
        return abc == null || i < 0 || i > 2 ? null : abc.get(i).getCMLVector3();
    }

    public double getVolume() {
        CMLElements<CMLLatticeVector> latticeVectors = this.getLatticeVectorElements();
        if (latticeVectors.size() != 3) {
            throw new RuntimeException("Cannot calculate volume without vectors");
        }
        return this.getCMLVector3(0).getScalarTripleProduct(this.getCMLVector3(1), this.getCMLVector3(2));
    }

    public CMLLattice getReducedCell() {
        if (Math.abs(this.getVolume()) < 1.0E-14) {
            throw new RuntimeException("coplanar vectors");
        }
        ArrayList<CMLVector3> vList = new ArrayList<CMLVector3>();
        for (int i = 0; i < 3; ++i) {
            vList.add(new CMLVector3(this.getCMLVector3(i)));
        }
        this.sort(vList);
        boolean change = true;
        int count = 0;
        while (change || count++ < 10) {
            change = false;
            change = this.newVector(vList, 0, 1);
            if (!change) {
                change = this.newVector(vList, 0, 2);
            }
            if (change) continue;
            change = this.newVector(vList, 1, 2);
        }
        this.sort(vList);
        CMLLattice reducedLattice = new CMLLattice(new CMLLatticeVector((CMLVector3)vList.get(0)), new CMLLatticeVector((CMLVector3)vList.get(1)), new CMLLatticeVector((CMLVector3)vList.get(2)));
        return reducedLattice;
    }

    private void sort(List<CMLVector3> vList) {
        this.sort(vList, 0, 1);
        this.sort(vList, 1, 2);
        this.sort(vList, 0, 1);
    }

    private void sort(List<CMLVector3> vList, int i, int j) {
        CMLVector3 ti = vList.get(i);
        CMLVector3 tj = vList.get(j);
        if (tj.getLength() < ti.getLength()) {
            vList.set(j, ti);
            vList.set(i, tj);
        }
    }

    private boolean newVector(List<CMLVector3> vList, int i, int j) {
        CMLVector3 ti = vList.get(i);
        double li = ti.getLength();
        CMLVector3 tj = vList.get(j);
        double lj = tj.getLength();
        boolean change = false;
        CMLVector3 tij = ti.subtract(tj);
        if (tij.getLength() < li) {
            vList.set(i, tij);
            change = true;
        }
        if (!change && tij.getLength() < lj) {
            vList.set(j, tij);
            change = true;
        }
        if (!change) {
            tij = ti.plus(tj);
            if (tij.getLength() < li) {
                vList.set(i, tij);
                change = true;
            }
            if (!change && tij.getLength() < lj) {
                vList.set(j, tij);
                change = true;
            }
        }
        return change;
    }

    public String getString() {
        String s = "";
        for (CMLLatticeVector lv : this.getLatticeVectorElements()) {
            s = s + "[" + lv.getStringContent() + "]";
            s = s + "(" + lv.getCMLVector3().getLength() + ")";
        }
        return s;
    }
}

