/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.BondTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.MDLReader;
import org.openscience.cdk.smsd.labelling.CanonicalLabellingAdaptor;
import org.openscience.cdk.smsd.labelling.ICanonicalMoleculeLabeller;
import org.openscience.cdk.smsd.tools.ExtAtomContainerManipulator;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@Deprecated
public class MolHandler {
    private IAtomContainer atomContainer = null;
    private boolean removeHydrogen;
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MolHandler.class);
    private final ICanonicalMoleculeLabeller canonLabeler = new CanonicalLabellingAdaptor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MolHandler(String molFile, boolean removeHydrogen, boolean cleanMolecule) {
        MDLReader molRead = null;
        this.removeHydrogen = removeHydrogen;
        FileInputStream readMolecule = new FileInputStream(molFile);
        molRead = new MDLReader((Reader)new InputStreamReader(readMolecule));
        this.atomContainer = (IAtomContainer)molRead.read((IChemObject)new AtomContainer());
        molRead.close();
        readMolecule.close();
        if (removeHydrogen) {
            this.atomContainer = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(this.atomContainer);
        }
        if (cleanMolecule) {
            if (!this.isPseudoAtoms()) {
                this.atomContainer = this.canonLabeler.getCanonicalMolecule(this.atomContainer);
            }
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(this.atomContainer);
            CDKHydrogenAdder adder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)this.atomContainer.getBuilder());
            adder.addImplicitHydrogens(this.atomContainer);
            Aromaticity.cdkLegacy().apply(this.atomContainer);
            BondTools.makeUpDownBonds((IAtomContainer)this.atomContainer);
        }
        if (molRead == null) return;
        try {
            molRead.close();
            return;
        }
        catch (IOException ioe) {
            this.logger.warn((Object)"Couldn't close molReader: ", new Object[]{ioe.getMessage()});
            this.logger.debug((Object)ioe);
        }
        return;
        catch (IOException ex) {
            this.logger.debug((Object)ex);
            if (molRead == null) return;
            try {
                molRead.close();
                return;
            }
            catch (IOException ioe) {
                this.logger.warn((Object)"Couldn't close molReader: ", new Object[]{ioe.getMessage()});
                this.logger.debug((Object)ioe);
            }
            return;
        }
        catch (CDKException e) {
            System.err.println((Object)e);
            if (molRead == null) return;
            {
                catch (Throwable throwable) {
                    if (molRead == null) throw throwable;
                    try {
                        molRead.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        this.logger.warn((Object)"Couldn't close molReader: ", new Object[]{ioe.getMessage()});
                        this.logger.debug((Object)ioe);
                    }
                    throw throwable;
                }
            }
            try {
                molRead.close();
                return;
            }
            catch (IOException ioe) {
                this.logger.warn((Object)"Couldn't close molReader: ", new Object[]{ioe.getMessage()});
                this.logger.debug((Object)ioe);
            }
            return;
        }
    }

    public MolHandler(IAtomContainer container, boolean removeHydrogen, boolean cleanMolecule) {
        String molID = container.getID();
        this.removeHydrogen = removeHydrogen;
        this.atomContainer = container;
        if (removeHydrogen) {
            try {
                this.atomContainer = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(this.atomContainer);
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
            }
        } else {
            this.atomContainer = (IAtomContainer)container.getBuilder().newInstance(IAtomContainer.class, new Object[]{this.atomContainer});
        }
        if (cleanMolecule) {
            try {
                if (!this.isPseudoAtoms()) {
                    this.atomContainer = this.canonLabeler.getCanonicalMolecule(this.atomContainer);
                }
                ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(this.atomContainer);
                CDKHydrogenAdder adder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)this.atomContainer.getBuilder());
                adder.addImplicitHydrogens(this.atomContainer);
                Aromaticity.cdkLegacy().apply(this.atomContainer);
            }
            catch (CDKException ex) {
                this.logger.error((Object)ex);
            }
        }
        this.atomContainer.setID(molID);
    }

    public IAtomContainer getMolecule() {
        return this.atomContainer;
    }

    public boolean getRemoveHydrogenFlag() {
        return this.removeHydrogen;
    }

    private boolean isPseudoAtoms() {
        for (IAtom atoms : this.atomContainer.atoms()) {
            if (!(atoms instanceof IPseudoAtom)) continue;
            return true;
        }
        return false;
    }
}

