/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.structure;

import java.lang.reflect.Array;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.memory.IStateLong;

public class S64BitSet
implements IStateBitSet {
    private static final boolean CHECK = false;
    private static final int ADDRESS_BITS_PER_WORD = 6;
    protected static final int BITS_PER_WORD = 64;
    protected static final long WORD_MASK = -1L;
    private final IEnvironment environment;
    protected IStateLong[] words;
    protected final IStateInt wordsInUse;

    protected static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private static void requirePositiveIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Positive index expected. Got " + index);
        }
    }

    private void checkInvariants() {
        assert (this.wordsInUse.get() == 0 || this.words[this.wordsInUse.get() - 1].get() != 0L);
        assert (this.wordsInUse.get() >= 0 && this.wordsInUse.get() <= this.words.length);
        assert (this.wordsInUse.get() == this.words.length || this.words[this.wordsInUse.get()].get() == 0L);
    }

    private void recalculateWordsInUse() {
        int i;
        int n = this.wordsInUse.get();
        for (i = n - 1; i >= 0 && this.words[i].get() == 0L; --i) {
        }
        if (i + 1 < n) {
            this.wordsInUse.set(i + 1);
        }
    }

    public S64BitSet(IEnvironment environment) {
        this.environment = environment;
        this.wordsInUse = environment.makeInt(0);
        this.initWords(64);
    }

    public S64BitSet(IEnvironment environment, int nbits) {
        this.environment = environment;
        this.wordsInUse = environment.makeInt(0);
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        this.initWords(nbits);
    }

    private void initWords(int nbits) {
        this.words = new IStateLong[S64BitSet.wordIndex(nbits - 1) + 1];
        for (int i = 0; i < this.words.length; ++i) {
            this.words[i] = this.environment.makeLong(0L);
        }
    }

    public void ensureCapacity(int wordsRequired) {
        if (this.words.length < wordsRequired) {
            int request = Math.max(2 * this.words.length, wordsRequired);
            int oldSize = this.words.length;
            this.words = S64BitSet.copyOf(this.words, request);
            for (int i = oldSize; i < request; ++i) {
                this.words[i] = this.environment.makeLong(0L);
            }
        }
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return S64BitSet.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse.get() < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.wordsInUse.set(wordsRequired);
        }
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    @Override
    public void set(int bitIndex) {
        S64BitSet.requirePositiveIndex(bitIndex);
        int wordIndex = S64BitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        this.words[wordIndex].set(this.words[wordIndex].get() | 1L << bitIndex);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        S64BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = S64BitSet.wordIndex(fromIndex);
        int endWordIndex = S64BitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.words[startWordIndex].set(this.words[startWordIndex].get() | firstWordMask & lastWordMask);
        } else {
            this.words[startWordIndex].set(this.words[startWordIndex].get() | firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i].set(-1L);
            }
            this.words[endWordIndex].set(this.words[endWordIndex].get() | lastWordMask);
        }
    }

    @Override
    public void clear(int bitIndex) {
        S64BitSet.requirePositiveIndex(bitIndex);
        int wordIndex = S64BitSet.wordIndex(bitIndex);
        int n = this.wordsInUse.get();
        if (wordIndex >= n) {
            return;
        }
        this.words[wordIndex].set(this.words[wordIndex].get() & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL));
        this.recalculateWordsInUse();
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        S64BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int wiu = this.wordsInUse.get();
        int startWordIndex = S64BitSet.wordIndex(fromIndex);
        if (startWordIndex >= wiu) {
            return;
        }
        int endWordIndex = S64BitSet.wordIndex(toIndex - 1);
        if (endWordIndex >= wiu) {
            toIndex = this.length();
            endWordIndex = wiu - 1;
        }
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.words[startWordIndex].set(this.words[startWordIndex].get() & (firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL));
        } else {
            this.words[startWordIndex].set(this.words[startWordIndex].get() & (firstWordMask ^ 0xFFFFFFFFFFFFFFFFL));
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i].set(0L);
            }
            this.words[endWordIndex].set(this.words[endWordIndex].get() & (lastWordMask ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.recalculateWordsInUse();
    }

    @Override
    public void clear() {
        for (IStateLong word : this.words) {
            word.set(0L);
        }
        this.wordsInUse.set(0);
    }

    @Override
    public final boolean get(int bitIndex) {
        S64BitSet.requirePositiveIndex(bitIndex);
        int wordIndex = bitIndex >> 6;
        return wordIndex < this.wordsInUse.get() && (this.words[wordIndex].get() & 1L << bitIndex) != 0L;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int wiu = this.wordsInUse.get();
        int u = S64BitSet.wordIndex(fromIndex);
        if (u >= wiu) {
            return -1;
        }
        long word = this.words[u].get() & -1L << fromIndex;
        while (word == 0L) {
            if (++u == wiu) {
                return -1;
            }
            word = this.words[u].get();
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    @Override
    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int wiu = this.wordsInUse.get();
        int u = S64BitSet.wordIndex(fromIndex);
        if (u >= wiu) {
            return fromIndex;
        }
        long word = (this.words[u].get() ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == wiu) {
                return wiu * 64;
            }
            word = this.words[u].get() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    @Override
    public int prevSetBit(int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        int u = S64BitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse.get()) {
            return this.length() - 1;
        }
        long word = this.words[u].get() & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u].get();
        }
        return (u + 1) * 64 - 1 - Long.numberOfLeadingZeros(word);
    }

    @Override
    public int prevClearBit(int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        int u = S64BitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse.get()) {
            return fromIndex;
        }
        long word = (this.words[u].get() ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u].get() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (u + 1) * 64 - 1 - Long.numberOfLeadingZeros(word);
    }

    public int length() {
        int wiu = this.wordsInUse.get();
        if (wiu == 0) {
            return 0;
        }
        return 64 * (wiu - 1) + (64 - Long.numberOfLeadingZeros(this.words[wiu - 1].get()));
    }

    @Override
    public boolean isEmpty() {
        return this.wordsInUse.get() == 0;
    }

    @Override
    public int cardinality() {
        int sum = 0;
        for (int i = this.wordsInUse.get() - 1; i >= 0; --i) {
            sum += Long.bitCount(this.words[i].get());
        }
        return sum;
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.wordsInUse.get();
        while (--i >= 0) {
            h ^= this.words[i].get() * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    @Override
    public int size() {
        return this.words.length * 64;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IStateBitSet)) {
            return false;
        }
        IStateBitSet that = (IStateBitSet)o;
        if (this.cardinality() != that.cardinality()) {
            return false;
        }
        int i = this.nextSetBit(0);
        while (i >= 0) {
            if (!that.get(i)) {
                return false;
            }
            i = this.nextSetBit(i + 1);
        }
        return true;
    }

    public String toString() {
        int numBits = this.wordsInUse.get() > 128 ? this.cardinality() : this.wordsInUse.get() * 64;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            i = this.nextSetBit(i + 1);
            while (i >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i < endOfRun);
                i = this.nextSetBit(i + 1);
            }
        }
        b.append('}');
        return b.toString();
    }
}

