/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.flatten;

import java.util.Arrays;
import org.chocosolver.memory.trailing.StoredLong;
import org.chocosolver.memory.trailing.trail.IStoredLongTrail;

public class StoredLongTrail
implements IStoredLongTrail {
    private final double loadfactor;
    private StoredLong[] variableStack;
    private long[] valueStack;
    private int[] stampStack;
    private int currentLevel = 0;
    private int[] worldStartLevels;

    public StoredLongTrail(int nUpdates, int nWorlds, double loadfactor) {
        this.variableStack = new StoredLong[nUpdates];
        this.valueStack = new long[nUpdates];
        this.stampStack = new int[nUpdates];
        this.worldStartLevels = new int[nWorlds];
        this.loadfactor = loadfactor;
    }

    @Override
    public void worldPush(int worldIndex) {
        this.worldStartLevels[worldIndex] = this.currentLevel;
        if (worldIndex == this.worldStartLevels.length - 1) {
            this.worldStartLevels = Arrays.copyOf(this.worldStartLevels, (int)((double)this.worldStartLevels.length * this.loadfactor));
        }
    }

    @Override
    public void worldPop(int worldIndex) {
        int wsl = this.worldStartLevels[worldIndex];
        while (this.currentLevel > wsl) {
            --this.currentLevel;
            StoredLong v = this.variableStack[this.currentLevel];
            v._set(this.valueStack[this.currentLevel], this.stampStack[this.currentLevel]);
        }
    }

    @Override
    public void worldCommit(int worldIndex) {
        int startLevel = this.worldStartLevels[worldIndex];
        int prevWorld = worldIndex - 1;
        int writeIdx = startLevel;
        for (int level = startLevel; level < this.currentLevel; ++level) {
            StoredLong var = this.variableStack[level];
            long val = this.valueStack[level];
            int stamp = this.stampStack[level];
            var.overrideTimeStamp(prevWorld);
            if (stamp == prevWorld) continue;
            if (writeIdx != level) {
                this.valueStack[writeIdx] = val;
                this.variableStack[writeIdx] = var;
                this.stampStack[writeIdx] = stamp;
            }
            ++writeIdx;
        }
        this.currentLevel = writeIdx;
    }

    @Override
    public void savePreviousState(StoredLong v, long oldValue, int oldStamp) {
        this.valueStack[this.currentLevel] = oldValue;
        this.variableStack[this.currentLevel] = v;
        this.stampStack[this.currentLevel] = oldStamp;
        ++this.currentLevel;
        if (this.currentLevel == this.variableStack.length) {
            this.resizeUpdateCapacity();
        }
    }

    private void resizeUpdateCapacity() {
        int newCapacity = (int)((double)this.variableStack.length * this.loadfactor);
        StoredLong[] tmp1 = new StoredLong[newCapacity];
        System.arraycopy(this.variableStack, 0, tmp1, 0, this.variableStack.length);
        this.variableStack = tmp1;
        long[] tmp2 = new long[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
        int[] tmp3 = new int[newCapacity];
        System.arraycopy(this.stampStack, 0, tmp3, 0, this.stampStack.length);
        this.stampStack = tmp3;
    }
}

