/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

@Explained
public class PropGreaterOrEqualXC
extends Propagator<IntVar> {
    private final int constant;

    public PropGreaterOrEqualXC(IntVar var, int cste) {
        super((Variable[])new IntVar[]{var}, (Priority)PropagatorPriority.UNARY, false, true);
        this.constant = cste;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ((IntVar[])this.vars)[0].updateLowerBound(this.constant, this, Reason.undef());
        assert (((IntVar[])this.vars)[0].getLB() >= this.constant);
        this.setPassive();
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].getLB() >= this.constant) {
            return ESat.TRUE;
        }
        if (((IntVar[])this.vars)[0].getUB() < this.constant) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return ((IntVar[])this.vars)[0].getName() + " >= " + this.constant;
    }
}

