/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta;

import java.util.Arrays;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.util.tools.ArrayUtils;

public final class EnumDelta
extends TimeStampedObject
implements IEnumDelta {
    private static final int SIZE = 32;
    private int[] rem = new int[32];
    private ICause[] causes = new ICause[32];
    private int last;

    public EnumDelta(IEnvironment environment) {
        super(environment);
    }

    private void ensureCapacity() {
        if (this.last >= this.rem.length) {
            int nsize = ArrayUtils.newBoundedSize(this.last, this.rem.length * 2);
            this.rem = Arrays.copyOf(this.rem, nsize);
            this.causes = Arrays.copyOf(this.causes, nsize);
        }
    }

    @Override
    public void lazyClear() {
        if (this.needReset()) {
            this.last = 0;
            this.resetStamp();
        }
    }

    @Override
    public void add(int value, ICause cause) {
        this.lazyClear();
        this.ensureCapacity();
        this.causes[this.last] = cause;
        this.rem[this.last++] = value;
    }

    @Override
    public int get(int idx) {
        return this.rem[idx];
    }

    @Override
    public ICause getCause(int idx) {
        return this.causes[idx];
    }

    @Override
    public int size() {
        return this.last;
    }
}

