/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.mcfs.MCFSParams;
import dmLab.utils.ArrayUtils;
import dmLab.utils.GeneralUtils;
import dmLab.utils.MathUtils;
import java.util.Arrays;

public final class MCFSAutoParams {
    public static int AUTO = -1;
    private static String AUTO_LABEL = "auto";

    public static String valueToString(float value) {
        float f;
        if (value == (float)AUTO) {
            return AUTO_LABEL;
        }
        return Float.toString(f);
    }

    /*
     * WARNING - void declaration
     */
    public static float valueToFloat(String paramName, String value) {
        void var2_2;
        if (value.trim().equalsIgnoreCase(AUTO_LABEL)) {
            return AUTO;
        }
        try {
            float retVal = Float.valueOf(value).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            String string;
            System.err.println("Warning! Incorrect value of " + string + ": " + (String)var1_1 + ". Using default value = 'auto'.");
            return AUTO;
        }
        return (float)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int setProjectionSize(float projectionSize, int projectionSizeMin, int projectionSizeMax, FArray array) {
        void var0_1;
        void var3_4;
        float projectionSizeValue22;
        int projectionSizeValue22;
        FArray fArray = array;
        int attributes = fArray.attributes.length - 1;
        if (projectionSize == (float)AUTO) {
            projectionSizeValue22 = (int)Math.round(Math.sqrt(attributes));
        } else if (projectionSizeValue22 > 0.0f && projectionSizeValue22 < 1.0f) {
            projectionSizeValue22 = Math.round((float)attributes * projectionSizeValue22);
        } else if (projectionSizeValue22 >= 1.0f) {
            projectionSizeValue22 = (int)projectionSizeValue22;
        } else {
            System.err.println("Warning! Incorrect value of projectionSize:" + projectionSizeValue22 + ". Using default value = 'auto'.");
            projectionSizeValue22 = (int)Math.round(Math.sqrt(attributes));
        }
        fArray = var3_4;
        if (projectionSizeValue22 >= fArray.attributes.length) {
            System.err.println("Warning! projectionSize(m) is larger than number of attributes. Using max value = " + attributes);
            projectionSizeValue22 = attributes;
        }
        if (projectionSizeValue22 < projectionSizeMin) {
            void var1_2;
            System.err.println("Warning! ProjectionSize(m) < 1. Using min value = " + projectionSizeMin);
            projectionSizeValue22 = var1_2;
        }
        if (projectionSizeValue22 > projectionSizeMax) {
            void var2_3;
            System.err.println("Warning! ProjectionSize(m) = " + projectionSizeValue22 + ". Using max value = " + projectionSizeMax);
            projectionSizeValue22 = var2_3;
        }
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int setProjections(int projections, float projectionSize, int featureFreq, FArray array) {
        int n;
        int projectionsValue;
        int attributes = array.attributes.length - 1;
        if (projections == AUTO) {
            projectionsValue = Math.round((float)attributes / projectionSize * (float)featureFreq);
        } else if (projectionsValue <= 0) {
            void var2_2;
            void var1_1;
            void var3_4;
            System.err.println("Warning! Incorrect value of projections: " + projectionsValue + " Using default value = 'auto'.");
            projectionsValue = Math.round((float)var3_4 / var1_1 * (float)var2_2);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static float balanceModel(double ratio) {
        void var3_3;
        void var2_2;
        double d;
        int id;
        double[] ratioModel = new double[]{0.25, 0.2, 0.15, 0.1, 0.075, 0.05, 0.025, 0.01, 0.0075, 0.005, 0.0025, 0.001};
        double[] paramModel = new double[]{1.0, 1.0, 1.2, 1.5, 1.75, 2.0, 2.5, 3.0, 3.25, 3.5, 3.75, 4.0};
        for (id = 0; id < ratioModel.length && !(ratio > ratioModel[id]); ++id) {
        }
        if (id == 0) {
            return (float)paramModel[0];
        }
        if (id >= ratioModel.length) {
            int cfr_ignored_0 = paramModel.length;
            return (float)paramModel[11];
        }
        double a = (d - ratioModel[id - 1]) / (ratioModel[id] - var2_2[id - 1]);
        float f = (float)(paramModel[id - 1] + a * (paramModel[id] - var3_3[id - 1]));
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] getBalancedClassSizes(MCFSParams mcfsParams, FArray array) {
        void var0_1;
        void var2_4;
        void var1_2;
        float balanceValue;
        float balance = mcfsParams.balance;
        if (!array.isTargetNominal()) {
            return null;
        }
        int decIndex = array.getDecAttrIdx();
        int[] classSizes = ArrayUtils.distribution(array.getColumn(decIndex), array.getDecValues());
        float minSize = MathUtils.minValue(ArrayUtils.int2float(classSizes));
        float maxSize = MathUtils.maxValue(ArrayUtils.int2float(classSizes));
        float classSizeRatio = minSize / maxSize;
        int[] balancedClassSizes = (int[])classSizes.clone();
        if (balance == 0.0f) {
            balanceValue = 0.0f;
            balancedClassSizes = null;
        } else if (!(balanceValue >= 1.0f)) {
            if (balanceValue == (float)AUTO) {
                balanceValue = MCFSAutoParams.balanceModel(classSizeRatio);
            } else {
                System.err.println("Warning! Incorrect value of balance: " + balanceValue + " Using default value = 'auto'.");
                balanceValue = MCFSAutoParams.balanceModel(classSizeRatio);
            }
        }
        if (balanceValue > 1.0f) {
            double b = (double)minSize / Math.pow(minSize, 1.0 / (double)balanceValue);
            for (int i = 0; i < balancedClassSizes.length; ++i) {
                int newSize = (int)Math.ceil(b * Math.pow(balancedClassSizes[i], 1.0 / (double)balanceValue));
                if (balancedClassSizes[i] <= newSize) continue;
                balancedClassSizes[i] = newSize;
            }
        }
        if ((balanceValue == 0.0f || balanceValue == 1.0f) && (double)classSizeRatio < 0.1) {
            System.err.println("Warning! Classes are imbalanced (classSizeRatio = " + GeneralUtils.formatFloat(classSizeRatio, 5) + "). It is recomended to set mcfs.balance = auto");
        }
        System.out.print("Classes = " + Arrays.toString(array.dictionary.toString(var1_2.getDecValues())) + ", Sizes = " + Arrays.toString((int[])var2_4));
        if (balanceValue > 1.0f) {
            System.out.print(", balanced = " + Arrays.toString(balancedClassSizes));
        }
        System.out.println(", classSizeRatio = " + classSizeRatio + ", balanceValue = " + (float)var0_1);
        return balancedClassSizes;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] getSplitSetClassSizes(MCFSParams mcfsParams, FArray array) {
        void var2_4;
        int splitSetSize;
        if (!array.isTargetNominal()) {
            return null;
        }
        int[] splitSetClassSizes = null;
        if (mcfsParams.balance <= 1.0f & ((splitSetSize = mcfsParams.splitSetSize) == 0 | splitSetSize >= ((Array)array).rowsNumber())) {
            splitSetClassSizes = null;
        } else {
            int sum = MathUtils.sum(mcfsParams.balancedClassSizes);
            if (sum > splitSetSize) {
                splitSetClassSizes = mcfsParams.balancedClassSizes;
                for (int i = 0; i < splitSetClassSizes.length; ++i) {
                    splitSetClassSizes[i] = (int)Math.ceil((float)splitSetSize * (float)splitSetClassSizes[i] / (float)sum);
                }
            }
        }
        return var2_4;
    }
}

