/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.StringTokenizer;
import javalain.math.Calcul;
import javax.swing.JOptionPane;
import util.MsgUtils;

public class Matrice {
    private static double PRECISION = 1.0E-12;
    private double[][] element;
    private int nb_lig;
    private int nb_col;
    private String nom;

    public Matrice(String nom_fichier) {
        this(nom_fichier, 0);
    }

    public Matrice(String nom_fichier, int numero_du_jeu_de_donnees) {
        try {
            int ligne;
            FileReader fichier = new FileReader(nom_fichier);
            BufferedReader buffer = new BufferedReader(fichier);
            StringTokenizer st = new StringTokenizer(buffer.readLine());
            int lig = Integer.parseInt(st.nextToken());
            this.nb_col = Integer.parseInt(st.nextToken());
            this.nb_lig = st.hasMoreTokens() ? lig / Integer.parseInt(st.nextToken()) : lig;
            this.element = new double[this.nb_lig][this.nb_col];
            buffer.readLine();
            for (ligne = numero_du_jeu_de_donnees * this.nb_lig; ligne > 0; --ligne) {
                buffer.readLine();
            }
            for (ligne = 0; ligne < this.nb_lig; ++ligne) {
                st = new StringTokenizer(buffer.readLine());
                int colonne = 0;
                while (st.hasMoreTokens()) {
                    this.element[ligne][colonne++] = Double.parseDouble(st.nextToken());
                }
            }
            buffer.close();
            fichier.close();
            this.nom = nom_fichier;
        }
        catch (FileNotFoundException fnfe) {
            MsgUtils.erreurAndExit(null, "Fichier introuvable '" + nom_fichier + "'", "Chargement de la matrice");
        }
        catch (IOException e) {
            MsgUtils.erreurAndExit(null, "Probl\u00e8me lors de la lecture du fichier '" + nom_fichier + "'.", "Chargement de la matrice");
        }
    }

    public Matrice(int n, int p) {
        this.nb_lig = n;
        this.nb_col = p;
        this.element = new double[n][p];
        this.nom = "Matrice";
    }

    public Matrice(int n) {
        this(n, n);
    }

    public int nbLigne() {
        return this.nb_lig;
    }

    public int nbColonne() {
        return this.nb_col;
    }

    public double element(int i, int j) {
        return this.element[i][j];
    }

    public void setElement(int i, int j, double d) {
        this.element[i][j] = d;
    }

    public double[] ligne(int i) {
        double[] lig = new double[this.nb_col];
        System.arraycopy(this.element[i], 0, lig, 0, this.nb_col);
        return lig;
    }

    public double[] colonne(int j) {
        double[] col = new double[this.nb_lig];
        for (int i = 0; i < this.nb_lig; ++i) {
            col[i] = this.element[i][j];
        }
        return col;
    }

    public void swapColonne(int i, int j) {
        Matrice.swap(this, i, j);
    }

    private static void swap(Matrice m, int i, int j) {
        for (int k = 0; k < m.nb_lig; ++k) {
            double d = m.element[k][i];
            m.element[k][i] = m.element[k][j];
            m.element[k][j] = d;
        }
    }

    public void setNom(String s) {
        this.nom = s;
    }

    public String getNom() {
        return this.nom;
    }

    public void setIdentite() {
        if (this.nb_lig != this.nb_col) {
            MsgUtils.erreurAndExit(null, "Initialisation impossible car la matrice n'est pas carr\u00e9e.", "Matrice identit\u00e9");
        }
        for (int i = 0; i < this.nb_lig; ++i) {
            for (int j = 0; j < this.nb_col; ++j) {
                this.element[i][j] = i == j ? 1.0 : 0.0;
            }
        }
    }

    public boolean isSymetric() {
        for (int i = 0; i < this.nb_lig - 1; ++i) {
            for (int j = i + 1; j < this.nb_lig; ++j) {
                if (this.element[i][j] == this.element[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public void sauvegardeDansFichier(String nom) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nb_lig).append(" ").append(this.nb_col).append("\n\n");
        for (int i = 0; i < this.nb_lig; ++i) {
            for (int j = 0; j < this.nb_col - 1; ++j) {
                sb.append(this.element[i][j]).append(" ");
            }
            sb.append(this.element[i][this.nb_col - 1]).append("\n");
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(nom, "ISO-8859-1");
            out.print(sb.toString());
        }
        catch (IOException e) {
            // empty catch block
        }
        if (out != null) {
            out.close();
        }
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat("0.000000000000");
        double max = this.element[0][0];
        for (int i = 0; i < this.nb_lig; ++i) {
            for (int j = 0; j < this.nb_col; ++j) {
                if (!(Math.abs(this.element[i][j]) > max)) continue;
                max = Math.abs(this.element[i][j]);
            }
        }
        int nb_chiffre_max = 1;
        while (max >= 10.0) {
            max /= 10.0;
            ++nb_chiffre_max;
        }
        StringBuilder sb = new StringBuilder("----- ").append(this.nom).append(" (").append(this.nb_lig).append(",").append(this.nb_col).append(")\n");
        for (int i = 0; i < this.nb_lig; ++i) {
            for (int j = 0; j < this.nb_col; ++j) {
                double nb = this.element[i][j];
                int nb_chiffre = 1;
                double abs = Math.abs(nb);
                while (abs >= 10.0) {
                    abs /= 10.0;
                    ++nb_chiffre;
                }
                if (nb >= 0.0) {
                    sb.append(" ");
                }
                for (int k = 0; k < nb_chiffre_max - nb_chiffre; ++k) {
                    sb.append(" ");
                }
                sb.append(df.format(nb)).append(" ");
            }
            sb.append("\n");
        }
        sb.append("-----");
        return sb.toString();
    }

    public Matrice mul(Matrice b) {
        if (this.nb_col != b.nb_lig) {
            JOptionPane.showMessageDialog(null, "Les dimensions des matrices ne sont pas compatibles.", "Multiplication de matrices", 0);
            System.exit(0);
        }
        Matrice mul = new Matrice(this.nb_lig, b.nb_col);
        for (int i = 0; i < this.nb_lig; ++i) {
            for (int j = 0; j < b.nb_col; ++j) {
                double somme = 0.0;
                for (int k = 0; k < this.nb_col; ++k) {
                    somme += this.element[i][k] * b.element[k][j];
                }
                mul.element[i][j] = somme;
            }
        }
        return mul;
    }

    public Matrice addition(Matrice b) {
        if (this.nb_lig != b.nb_lig && this.nb_col != b.nb_col) {
            JOptionPane.showMessageDialog(null, "Les dimensions des matrices ne sont pas compatibles.", "Addition de matrices", 0);
            System.exit(0);
        }
        Matrice add = new Matrice(this.nb_lig, this.nb_col);
        for (int i = 0; i < this.nb_lig; ++i) {
            for (int j = 0; j < b.nb_col; ++j) {
                add.element[i][j] = this.element[i][j] + b.element[i][j];
            }
        }
        return add;
    }

    public Matrice soustraction(Matrice b) {
        if (this.nb_lig != b.nb_lig && this.nb_col != b.nb_col) {
            JOptionPane.showMessageDialog(null, "Les dimensions des matrices ne sont pas compatibles.", "Soustraction de matrices", 0);
            System.exit(0);
        }
        Matrice add = new Matrice(this.nb_lig, this.nb_col);
        for (int i = 0; i < this.nb_lig; ++i) {
            for (int j = 0; j < b.nb_col; ++j) {
                add.element[i][j] = this.element[i][j] - b.element[i][j];
            }
        }
        return add;
    }

    public Matrice pow(double nb) {
        int i;
        if (this.nb_col != this.nb_lig) {
            JOptionPane.showMessageDialog(null, "La matrice n'est pas carr\u00e9e.", "Puissance de la matrice", 0);
            System.exit(0);
        }
        Matrice m_vecteurs_propres = new Matrice(this.nb_lig);
        double[] valeurs_propres = new double[this.nb_lig];
        Matrice.jacobi(this, valeurs_propres, m_vecteurs_propres);
        Matrice m_valeurs_propres = new Matrice(this.nb_lig);
        m_valeurs_propres.setIdentite();
        for (i = 0; i < this.nb_lig; ++i) {
            m_valeurs_propres.element[i][i] = valeurs_propres[i];
        }
        for (i = 0; i < m_valeurs_propres.nb_lig; ++i) {
            m_valeurs_propres.element[i][i] = -PRECISION < m_valeurs_propres.element[i][i] && m_valeurs_propres.element[i][i] < PRECISION ? 0.0 : Math.pow(m_valeurs_propres.element[i][i], nb);
        }
        return m_vecteurs_propres.mul(m_valeurs_propres).mul(m_vecteurs_propres.transpose());
    }

    public Matrice transpose() {
        Matrice m = new Matrice(this.nb_col, this.nb_lig);
        for (int i = 0; i < this.nb_lig; ++i) {
            for (int j = 0; j < this.nb_col; ++j) {
                m.element[j][i] = this.element[i][j];
            }
        }
        return m;
    }

    public Matrice mulScalaire(double d) {
        Matrice m = new Matrice(this.nb_lig, this.nb_col);
        for (int i = 0; i < this.nb_lig; ++i) {
            for (int j = 0; j < this.nb_col; ++j) {
                m.element[i][j] = this.element[i][j] * d;
            }
        }
        return m;
    }

    public Matrice centre() {
        int i;
        double[] moyenne_en_colonne = new double[this.nb_col];
        for (int j = 0; j < this.nb_col; ++j) {
            double somme = 0.0;
            for (i = 0; i < this.nb_lig; ++i) {
                somme += this.element[i][j];
            }
            moyenne_en_colonne[j] = somme / (double)this.nb_lig;
        }
        Matrice m = new Matrice(this.nb_lig, this.nb_col);
        for (i = 0; i < this.nb_lig; ++i) {
            for (int j = 0; j < this.nb_col; ++j) {
                m.element[i][j] = this.element[i][j] - moyenne_en_colonne[j];
            }
        }
        return m;
    }

    public Matrice centreReduite() {
        double[] moyenne_en_colonne = new double[this.nb_col];
        double[] ecart_type_en_colonne = new double[this.nb_col];
        for (int i = 0; i < this.nb_col; ++i) {
            double[] col = this.colonne(i);
            moyenne_en_colonne[i] = Calcul.moyenne(col);
            ecart_type_en_colonne[i] = Calcul.ecartType(col);
        }
        Matrice m = new Matrice(this.nb_lig, this.nb_col);
        for (int i = 0; i < this.nb_lig; ++i) {
            for (int j = 0; j < this.nb_col; ++j) {
                m.element[i][j] = (this.element[i][j] - moyenne_en_colonne[j]) / ecart_type_en_colonne[j];
            }
        }
        return m;
    }

    public Matrice varianceCovariance() {
        Matrice mat_centree = this.centre();
        return mat_centree.transpose().mul(mat_centree).mulScalaire(1.0 / (double)(this.nb_lig - 1));
    }

    public Matrice spherique() {
        Matrice mat_cov = this.varianceCovariance();
        return this.centre().mul(mat_cov.pow(-0.5));
    }

    public static Matrice createMatriceColonne(double[] a) {
        Matrice mat = new Matrice(a.length, 1);
        for (int i = 0; i < a.length; ++i) {
            mat.element[i][0] = a[i];
        }
        return mat;
    }

    public static Matrice createMatriceLigne(double[] a) {
        Matrice mat = new Matrice(1, a.length);
        System.arraycopy(a, 0, mat.element[0], 0, a.length);
        return mat;
    }

    public static void jacobi(Matrice mat, double[] e, Matrice E) {
        double c;
        int l;
        int m;
        int k;
        int i;
        if (mat.nb_col != mat.nb_lig) {
            JOptionPane.showMessageDialog(null, "La matrice n'est pas carr\u00e9e.", "M\u00e9thode de Jacobi", 0);
            System.exit(0);
        }
        int n = mat.nb_lig;
        double[][] S = new double[n][n];
        for (i = 0; i < n; ++i) {
            System.arraycopy(mat.element[i], 0, S[i], 0, n);
        }
        int[] ind = new int[n];
        boolean[] changed = new boolean[n];
        int state = n;
        E.setNom("Vecteurs propres");
        E.setIdentite();
        for (k = 0; k < n; ++k) {
            ind[k] = Matrice.maxint(S, n, k);
            e[k] = S[k][k];
            changed[k] = true;
        }
        while (state != 0) {
            m = 0;
            for (k = 1; k < n - 1; ++k) {
                if (!(Math.abs(S[k][ind[k]]) > Math.abs(S[m][ind[m]]))) continue;
                m = k;
            }
            k = m;
            l = ind[m];
            double p = S[k][l];
            double y = (e[l] - e[k]) / 2.0;
            double t = Math.abs(y) + Math.sqrt(p * p + y * y);
            double s = Math.sqrt(p * p + t * t);
            c = t / s;
            s = p / s;
            t = p * p / t;
            if (y < 0.0) {
                s = -s;
                t = -t;
            }
            S[k][l] = 0.0;
            state += Matrice.update(changed, e, k, -t);
            state += Matrice.update(changed, e, l, t);
            for (i = 0; i < k; ++i) {
                Matrice.rotate(S, i, k, i, l, c, s);
            }
            for (i = k + 1; i < l; ++i) {
                Matrice.rotate(S, k, i, i, l, c, s);
            }
            for (i = l + 1; i < n; ++i) {
                Matrice.rotate(S, k, i, l, i, c, s);
            }
            for (i = 0; i < n; ++i) {
                Matrice.rotate(E.element, k, i, l, i, c, s);
            }
            ind[k] = Matrice.maxint(S, n, k);
            ind[l] = Matrice.maxint(S, n, l);
        }
        for (k = 0; k < E.nb_lig; ++k) {
            for (l = k + 1; l < E.nb_lig; ++l) {
                c = E.element[k][l];
                E.element[k][l] = E.element[l][k];
                E.element[l][k] = c;
            }
        }
        for (k = 0; k < n; ++k) {
            m = k;
            for (l = k + 1; l < n; ++l) {
                if (!(e[l] > e[m])) continue;
                m = l;
            }
            if (k == m) continue;
            double d = e[m];
            e[m] = e[k];
            e[k] = d;
            Matrice.swap(E, m, k);
        }
    }

    private static int maxint(double[][] S, int n, int k) {
        int m = k + 1;
        for (int i = k + 2; i < n; ++i) {
            if (!(Math.abs(S[k][i]) > Math.abs(S[k][m]))) continue;
            m = i;
        }
        return m;
    }

    private static int update(boolean[] changed, double[] e, int k, double t) {
        double y = e[k];
        e[k] = y + t;
        if (changed[k] && y == e[k]) {
            changed[k] = false;
            return -1;
        }
        if (!changed[k] && y != e[k]) {
            changed[k] = true;
            return 1;
        }
        return 0;
    }

    private static void rotate(double[][] S, int k, int l, int i, int j, double c, double s) {
        double kl = S[k][l];
        double ij = S[i][j];
        S[k][l] = c * kl - s * ij;
        S[i][j] = s * kl + c * ij;
    }

    public void supprLignes(int[] tab_num_lig) {
        Arrays.sort(tab_num_lig);
        double[][] new_mat = new double[this.nb_lig - tab_num_lig.length][this.nb_col];
        int cpt = 0;
        for (int lig = 0; lig < this.nb_lig - tab_num_lig.length; ++lig) {
            if (cpt < tab_num_lig.length && lig == tab_num_lig[cpt] - 1 - cpt) {
                ++cpt;
            }
            System.arraycopy(this.element[lig + cpt], 0, new_mat[lig], 0, this.nb_col);
        }
        this.nb_lig -= tab_num_lig.length;
        this.element = new_mat;
    }
}

