/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.rulesys.impl.RuleStore;
import com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.GoalResults;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.GoalState;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.GoalTable;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.RuleState;
import com.hp.hpl.jena.util.PrintUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BRuleEngine {
    protected LinkedList agenda = new LinkedList();
    protected GoalTable goalTable;
    protected BackwardRuleInfGraphI infGraph;
    protected RuleStore ruleStore;
    protected boolean traceOn = false;
    protected boolean recordDerivations;
    protected long nRulesFired = 0L;
    protected int batchSize = 100000;
    static Log logger = LogFactory.getLog((Class)BRuleEngine.class);

    public BRuleEngine(BackwardRuleInfGraphI infGraph, RuleStore rules) {
        this.infGraph = infGraph;
        this.goalTable = new GoalTable(this);
        this.ruleStore = rules;
    }

    public BRuleEngine(BackwardRuleInfGraphI infGraph) {
        this.infGraph = infGraph;
        this.goalTable = new GoalTable(this);
        this.ruleStore = new RuleStore();
    }

    public synchronized void reset() {
        this.agenda.clear();
        this.goalTable.reset();
    }

    public void addRule(Rule rule) {
        this.ruleStore.addRule(rule);
    }

    public void deleteRule(Rule rule) {
        this.ruleStore.deleteRule(rule);
    }

    public List getAllRules() {
        return this.ruleStore.getAllRules();
    }

    public void deleteAllRules() {
        this.ruleStore.deleteAllRules();
    }

    public synchronized void halt() {
        Iterator i = this.agenda.iterator();
        while (i.hasNext()) {
            RuleState item = (RuleState)i.next();
            if (item.goalState == null) continue;
            item.goalState.close();
        }
        this.agenda.clear();
        this.goalTable.removePartialGoals();
    }

    public synchronized GoalState findGoal(TriplePattern goal) {
        return this.goalTable.findGoal(goal);
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    public long getNRulesFired() {
        return this.nRulesFired;
    }

    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
    }

    public void dump() {
        this.goalTable.dump();
    }

    public synchronized void appendToAgenda(RuleState rs) {
        if (!rs.isScheduled) {
            if (this.traceOn) {
                // empty if block
            }
            this.agenda.add(rs);
            rs.isScheduled = true;
        }
    }

    public synchronized void prependToAgenda(RuleState rs) {
        if (!rs.isScheduled) {
            if (this.traceOn) {
                // empty if block
            }
            this.agenda.add(0, rs);
            rs.isScheduled = true;
        }
    }

    public RuleState nextAgendaItem() {
        RuleState next = (RuleState)this.agenda.removeFirst();
        next.isScheduled = false;
        return next;
    }

    public List rulesFor(TriplePattern goal) {
        return this.ruleStore.rulesFor(goal);
    }

    public BackwardRuleInfGraphI getInfGraph() {
        return this.infGraph;
    }

    public boolean processBuiltin(ClauseEntry clause, Rule rule, BindingEnvironment env) {
        return this.infGraph.processBuiltin(clause, rule, env);
    }

    public synchronized Triple next(GoalState topGoalState) {
        GoalResults topGoal = topGoalState.getGoalResultsEntry();
        int numResults = 0;
        BindingVector env = null;
        RuleState current = null;
        RuleState continuation = null;
        try {
            while (true) {
                Object result;
                boolean foundResult = false;
                RuleState delayedRSClose = null;
                if (current == null) {
                    current = this.nextAgendaItem();
                    numResults = 0;
                    if (this.traceOn) {
                        logger.debug((Object)("Waken:   " + current));
                    }
                }
                if ((result = current.next()) == StateFlag.FAIL) {
                    if (this.traceOn) {
                        logger.debug((Object)"Failed");
                    }
                    delayedRSClose = current;
                    current = current.prev;
                } else if (result == StateFlag.SUSPEND) {
                    if (this.traceOn) {
                        logger.debug((Object)("Suspend: " + current));
                    }
                    GoalResults waitingFor = current.goalState.results;
                    waitingFor.addDependent(current);
                    current = current.prev;
                } else if (result == StateFlag.SATISFIED) {
                    foundResult = true;
                    env = current.env;
                    delayedRSClose = current;
                    continuation = current.prev;
                } else {
                    env = current.newEnvironment((Triple)result);
                    if (env == null) continue;
                    Rule rule = current.ruleInstance.rule;
                    boolean foundGoal = false;
                    int maxClause = rule.bodyLength();
                    int clauseIndex = current.nextClauseIndex();
                    while (clauseIndex < maxClause && !foundGoal) {
                        ClauseEntry clause;
                        if ((clause = rule.getBodyElement(clauseIndex++)) instanceof TriplePattern) {
                            TriplePattern subgoal = env.partInstantiate((TriplePattern)clause);
                            if (!subgoal.isLegal()) {
                                delayedRSClose = current;
                                current = current.prev;
                            } else {
                                current = new RuleState(current, subgoal, clauseIndex, env);
                            }
                            foundGoal = true;
                            continue;
                        }
                        if (this.infGraph.processBuiltin(clause, rule, env)) continue;
                        delayedRSClose = current;
                        current = current.prev;
                        foundGoal = true;
                    }
                    if (!foundGoal) {
                        foundResult = true;
                        continuation = current;
                    }
                }
                if (foundResult) {
                    GoalResults resultDest = current.ruleInstance.generator;
                    Triple finalResult = current.getResult(env);
                    if (this.traceOn) {
                        logger.debug((Object)("Result:  " + PrintUtil.print(finalResult) + " <- " + current + ", newenv=" + env));
                    }
                    boolean newresult = resultDest.addResult(finalResult);
                    if (delayedRSClose != null) {
                        delayedRSClose.close();
                    }
                    ++numResults;
                    current = continuation;
                    ++this.nRulesFired;
                    if (newresult && this.recordDerivations) {
                        Rule rule = current.ruleInstance.rule;
                        ArrayList<Triple> matchList = new ArrayList<Triple>(rule.bodyLength());
                        for (int i = 0; i < rule.bodyLength(); ++i) {
                            ClauseEntry clause = rule.getBodyElement(i);
                            if (!(clause instanceof TriplePattern)) continue;
                            matchList.add(env.instantiate((TriplePattern)clause));
                        }
                        RuleDerivation derivation = new RuleDerivation(rule, finalResult, matchList, this.infGraph);
                        this.infGraph.logDerivation(finalResult, derivation);
                    }
                    if (newresult && resultDest == topGoal) {
                        if (current != null) {
                            this.prependToAgenda(current);
                        }
                        return finalResult;
                    }
                    if (numResults <= this.batchSize) continue;
                    if (current != null) {
                        this.appendToAgenda(current);
                    }
                    current = null;
                    continue;
                }
                if (delayedRSClose == null) continue;
                delayedRSClose.close();
            }
        }
        catch (NoSuchElementException e) {
            if (this.traceOn) {
                logger.debug((Object)"Completed all");
            }
            this.goalTable.setAllComplete();
            return null;
        }
    }
}

