/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.LocaleUtility;
import com.ibm.icu.impl.ZoneInfoExt;
import com.ibm.icu.impl.ZoneMetaData;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class ZoneMeta {
    private static Map canonicalMap = null;
    public static final int PREFIX = 0;
    public static final int HOUR = 1;
    public static final int GMT = 2;
    public static final int REGION_FORMAT = 3;
    public static final int FALLBACK_FORMAT = 4;
    private static final String[][] TZ_LOCALIZATION_INFO = new String[][]{{"am", "+HHmm;-HHmm"}, {"bg", "+HHmm;-HHmm", "\u0413\u0440\u0438\u0438\u043d\u0443\u0438\u0447{0}"}, {"cy", "+HHmm;-HHmm"}, {"el", "+HHmm;-HHmm"}, {"hr", "+HHmm;-HHmm"}, {"ja", "+HHmm;-HHmm", null, "{0}\u6642\u9593", "{0} ({1})\u6642\u9593"}, {"nn", "+HH.mm;-HH.mm"}, {"sk", "+HHmm;-HHmm"}, {"sl", "+HHmm;-HHmm"}, {"sr", "+HHmm;-HHmm"}, {"sv", "+HH.mm;-HH.mm", "GMT"}, {"th", "+HHmm;-HHmm"}, {"uk", "+HHmm;-HHmm"}, {"zh_Hant", "+HH:mm;-HH:mm"}, {"zh", "+HHmm;-HHmm"}, {null, "+HH:mm;-HH:mm", "GMT{0}", "{0}", "{0} ({1})"}};
    private static final String[] EMPTY = new String[0];
    private static Map COUNTRY_MAP = null;
    private static Map EQUIV_MAP = null;

    public static synchronized String[] getAvailableIDs(String country) {
        String[] result;
        if (country == null) {
            country = "";
        }
        if (COUNTRY_MAP == null) {
            Set valid = ZoneMeta.getValidIDs();
            TreeSet unused = new TreeSet(valid);
            ArrayList<String> list = new ArrayList<String>();
            COUNTRY_MAP = new TreeMap();
            for (int i = 0; i < ZoneMetaData.COUNTRY.length; ++i) {
                String[] z = ZoneMetaData.COUNTRY[i];
                list.clear();
                for (int j = 1; j < z.length; ++j) {
                    if (!valid.contains(z[j])) continue;
                    list.add(z[j]);
                    unused.remove(z[j]);
                }
                COUNTRY_MAP.put(z[0], list.toArray(EMPTY));
            }
            if (unused.size() > 0) {
                list.clear();
                list.addAll(Arrays.asList((String[])COUNTRY_MAP.get("")));
                list.addAll(unused);
                Collections.sort(list);
                COUNTRY_MAP.put("", list.toArray(EMPTY));
            }
        }
        if ((result = (String[])COUNTRY_MAP.get(country)) == null) {
            result = EMPTY;
        }
        return result;
    }

    public static synchronized int countEquivalentIDs(String id) {
        String[] result;
        if (EQUIV_MAP == null) {
            ZoneMeta.createEquivMap();
        }
        return (result = (String[])EQUIV_MAP.get(id)) == null ? 0 : result.length;
    }

    public static synchronized String getEquivalentID(String id, int index) {
        String[] a;
        if (EQUIV_MAP == null) {
            ZoneMeta.createEquivMap();
        }
        return (a = (String[])EQUIV_MAP.get(id)) != null && index >= 0 && index < a.length ? a[index] : "";
    }

    private static void createEquivMap() {
        EQUIV_MAP = new TreeMap();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ZoneMetaData.EQUIV.length; ++i) {
            String[] z = ZoneMetaData.EQUIV[i];
            list.clear();
            for (int j = 0; j < z.length; ++j) {
                list.add(z[j]);
            }
            if (list.size() <= 1) continue;
            String[] a = list.toArray(EMPTY);
            for (int j = 0; j < a.length; ++j) {
                EQUIV_MAP.put(a[j], a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getCanonicalInfo(String id) {
        if (canonicalMap == null) {
            HashMap<String, String[]> m = new HashMap<String, String[]>();
            for (int i = 0; i < ZoneInfoExt.CLDR_INFO.length; ++i) {
                String[] clist = ZoneInfoExt.CLDR_INFO[i];
                String c = clist[0];
                m.put(c, clist);
                for (int j = 3; j < clist.length; ++j) {
                    m.put(clist[j], clist);
                }
            }
            Class clazz = ZoneMeta.class;
            synchronized (clazz) {
                canonicalMap = m;
            }
        }
        return (String[])canonicalMap.get(id);
    }

    public static String getCanonicalID(String tzid) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info != null) {
            return info[0];
        }
        return tzid;
    }

    public static String getCanonicalCountry(String tzid) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info != null) {
            return info[1];
        }
        return null;
    }

    public static String getSingleCountry(String tzid) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info != null && info[2] != null) {
            return info[1];
        }
        return null;
    }

    public static String displayFallback(String tzid, String city, ULocale locale) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info == null) {
            return null;
        }
        String country_code = info[1];
        if (country_code == null) {
            return null;
        }
        String country = null;
        if (country_code != null) {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", locale);
            String rblocname = rb.getULocale().getBaseName();
            if (LocaleUtility.isFallbackOf(rblocname, locale.getBaseName())) {
                country = ULocale.getDisplayCountry("xx_" + country_code, locale);
            }
            if (country == null || country.length() == 0) {
                country = country_code;
            }
        }
        if (info[2] != null) {
            return ZoneMeta.displayRegion(country, locale);
        }
        if (city == null) {
            city = tzid.substring(tzid.lastIndexOf(47) + 1).replace('_', ' ');
        }
        String flbPat = ZoneMeta.getTZLocalizationInfo(locale, 4);
        MessageFormat mf = new MessageFormat(flbPat);
        return mf.format(new Object[]{city, country});
    }

    public static String displayRegion(String cityOrCountry, ULocale locale) {
        String regPat = ZoneMeta.getTZLocalizationInfo(locale, 3);
        MessageFormat mf = new MessageFormat(regPat);
        return mf.format(new Object[]{cityOrCountry});
    }

    public static String displayGMT(long value, ULocale locale) {
        String msgpat = ZoneMeta.getTZLocalizationInfo(locale, 2);
        String dtepat = ZoneMeta.getTZLocalizationInfo(locale, 1);
        int n = dtepat.indexOf(59);
        if (n != -1) {
            if (value < 0L) {
                value = -value;
                dtepat = dtepat.substring(n + 1);
            } else {
                dtepat = dtepat.substring(0, n);
            }
        }
        long mph = 3600000L;
        long mpm = 60000L;
        SimpleDateFormat sdf = new SimpleDateFormat(dtepat, locale);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String res = sdf.format(new Long(value));
        MessageFormat mf = new MessageFormat(msgpat);
        res = mf.format(new Object[]{res});
        return res;
    }

    public static String getTZLocalizationInfo(ULocale locale, int index) {
        String baseName = locale.getBaseName();
        for (int i = 0; i < TZ_LOCALIZATION_INFO.length; ++i) {
            String[] info = TZ_LOCALIZATION_INFO[i];
            String prefix = info[0];
            if (prefix != null && (index >= info.length || info[index] == null || baseName.indexOf(prefix) != 0)) continue;
            return info[index];
        }
        throw new InternalError();
    }

    private static Set getValidIDs() {
        TreeSet<String> valid = new TreeSet<String>();
        valid.addAll(Arrays.asList(java.util.TimeZone.getAvailableIDs()));
        return valid;
    }
}

