/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IMutator;
import net.sourceforge.jclec.IPopulation;
import net.sourceforge.jclec.ISystem;
import net.sourceforge.jclec.util.random.IRandGen;

public abstract class AbstractMutator
implements IMutator {
    protected IPopulation context;
    protected IRandGen randgen;
    protected transient List<IIndividual> parentsBuffer;
    protected transient List<IIndividual> sonsBuffer;
    protected transient int parentsCounter;

    @Override
    public final void contextualize(ISystem context) {
        if (!(context instanceof IPopulation)) {
            throw new IllegalArgumentException("This object uses a population as execution context");
        }
        this.context = (IPopulation)context;
        this.randgen = context.createRandGen();
    }

    @Override
    public final List<IIndividual> mutate(List<IIndividual> parents) {
        this.parentsBuffer = parents;
        this.prepareMutation();
        this.sonsBuffer = new ArrayList<IIndividual>();
        this.parentsCounter = 0;
        while (this.parentsCounter < parents.size()) {
            this.mutateNext();
            ++this.parentsCounter;
        }
        return this.sonsBuffer;
    }

    protected abstract void prepareMutation();

    protected abstract void mutateNext();
}

