/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.ImbalancedClassification.Ensembles.Basic;

import keel.Algorithms.ImbalancedClassification.Ensembles.Basic.Metodo;
import keel.Algorithms.ImbalancedClassification.Ensembles.Basic.Referencia;
import keel.Dataset.Attributes;

public class KNN {
    public static int evaluacionKNN(int nvec, double[][] conj, int[] clases, double[] ejemplo, int nClases) {
        return KNN.evaluacionKNN2(nvec, conj, clases, ejemplo, nClases);
    }

    public static int evaluacionKNN2(int nvec, double[][] conj, int[] clases, double[] ejemplo, int nClases) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], ejemplo);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        return votada;
    }

    public static int[] evaluacionKNN3(int nvec, double[][] conj, int[] clases, double[] ejemplo, int nClases) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] vecinosCercanos = new int[nvec];
        int[] clasesVecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            clasesVecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], ejemplo);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < vecinosCercanos.length; ++j) {
            if (vecinosCercanos[j] == -1) continue;
            clasesVecinosCercanos[j] = clases[vecinosCercanos[j]];
        }
        return clasesVecinosCercanos;
    }

    public static int evaluacionKNN2(int nvec, double[][] conj, int[] clases, double[] ejemplo, int nClases, Referencia nVotos) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], ejemplo);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        nVotos.entero = votaciones;
        return votada;
    }

    public static int evaluacionKNN2(int nvec, double[][] conj, int[] clases, double[] ejemplo, int nClases, int[] vecinos) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], ejemplo);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        for (i = 0; i < vecinosCercanos.length; ++i) {
            vecinos[i] = vecinosCercanos[i];
        }
        return votada;
    }

    public static double distancia(double[] ej1, double[] ej2) {
        double suma = 0.0;
        for (int i = 0; i < ej1.length; ++i) {
            suma += (ej1[i] - ej2[i]) * (ej1[i] - ej2[i]);
        }
        suma = Math.sqrt(suma);
        return suma;
    }

    public static double distancia2(double[] ej1, double[] ej2) {
        double suma = 0.0;
        for (int i = 0; i < ej1.length; ++i) {
            suma += (ej1[i] - ej2[i]) * (ej1[i] - ej2[i]);
        }
        return suma;
    }

    public static int evaluacionKNN(int nvec, double[][] conj, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double[] ejemplo, double[] ejReal, int[] ejNominal, boolean[] ejNulos, int nClases, boolean distance) {
        return KNN.evaluacionKNN2(nvec, conj, real, nominal, nulos, clases, ejemplo, ejReal, ejNominal, ejNulos, nClases, distance);
    }

    public static int evaluacionKNN2(int nvec, double[][] conj, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double[] ejemplo, double[] ejReal, int[] ejNominal, boolean[] ejNulos, int nClases, boolean distance) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], real[i], nominal[i], nulos[i], ejemplo, ejReal, ejNominal, ejNulos, distance);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        return votada;
    }

    public static int evaluacionKNN2(int nvec, double[][] conj, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double[] ejemplo, double[] ejReal, int[] ejNominal, boolean[] ejNulos, int nClases, boolean distance, Referencia nVotos) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], real[i], nominal[i], nulos[i], ejemplo, ejReal, ejNominal, ejNulos, distance);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        nVotos.entero = votaciones;
        return votada;
    }

    public static int[] evaluacionKNN3(int nvec, double[][] conj, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double[] ejemplo, double[] ejReal, int[] ejNominal, boolean[] ejNulos, int nClases, boolean distance) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] vecinosCercanos = new int[nvec];
        int[] clasesVecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            clasesVecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], real[i], nominal[i], nulos[i], ejemplo, ejReal, ejNominal, ejNulos, distance);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < vecinosCercanos.length; ++j) {
            if (vecinosCercanos[j] == -1) continue;
            clasesVecinosCercanos[j] = clases[vecinosCercanos[j]];
        }
        return clasesVecinosCercanos;
    }

    public static int evaluacionKNN2(int nvec, double[][] conj, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double[] ejemplo, double[] ejReal, int[] ejNominal, boolean[] ejNulos, int nClases, boolean distance, int[] vecinos) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], real[i], nominal[i], nulos[i], ejemplo, ejReal, ejNominal, ejNulos, distance);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        for (i = 0; i < vecinosCercanos.length; ++i) {
            vecinos[i] = vecinosCercanos[i];
        }
        return votada;
    }

    public static double distancia(double[] ej1, double[] ej1Real, int[] ej1Nom, boolean[] ej1Nul, double[] ej2, double[] ej2Real, int[] ej2Nom, boolean[] ej2Nul, boolean Euc) {
        double suma = 0.0;
        if (Euc) {
            for (int i = 0; i < ej1.length; ++i) {
                suma += (ej1[i] - ej2[i]) * (ej1[i] - ej2[i]);
            }
            suma = Math.sqrt(suma);
        } else {
            for (int i = 0; i < ej1.length; ++i) {
                if (ej1Nul[i] || ej2Nul[i]) {
                    suma += 1.0;
                    continue;
                }
                if (Attributes.getInputAttribute(i).getType() == 0) {
                    suma += Metodo.nominalDistance[i][ej1Nom[i]][ej2Nom[i]];
                    continue;
                }
                if (Metodo.stdDev[i] == 0.0) continue;
                suma += Math.abs(ej1Real[i] - ej2Real[i]) / (4.0 * Metodo.stdDev[i]);
            }
            suma = Math.sqrt(suma);
        }
        return suma;
    }

    public static double distancia2(double[] ej1, double[] ej1Real, int[] ej1Nom, boolean[] ej1Nul, double[] ej2, double[] ej2Real, int[] ej2Nom, boolean[] ej2Nul, boolean Euc) {
        double suma = 0.0;
        if (Euc) {
            for (int i = 0; i < ej1.length; ++i) {
                suma += (ej1[i] - ej2[i]) * (ej1[i] - ej2[i]);
            }
        } else {
            for (int i = 0; i < ej1.length; ++i) {
                if (ej1Nul[i] || ej2Nul[i]) {
                    suma += 1.0;
                    continue;
                }
                if (Attributes.getInputAttribute(i).getType() == 0) {
                    suma += Metodo.nominalDistance[i][ej1Nom[i]][ej2Nom[i]];
                    continue;
                }
                if (Metodo.stdDev[i] == 0.0) continue;
                suma += Math.abs(ej1Real[i] - ej2Real[i]) / (4.0 * Metodo.stdDev[i]);
            }
        }
        return suma;
    }
}

