/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import org.w3c.dom.Element;
import weka.core.Attribute;

public abstract class FieldMetaInfo
implements Serializable {
    private static final long serialVersionUID = -6116715567129830143L;
    protected String m_fieldName;
    protected Optype m_optype = Optype.NONE;

    public Optype getOptype() {
        return this.m_optype;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public FieldMetaInfo(Element field) {
        this.m_fieldName = field.getAttribute("name");
        String opType = field.getAttribute("optype");
        if (opType != null && opType.length() > 0) {
            for (Optype o : Optype.values()) {
                if (!o.toString().equals(opType)) continue;
                this.m_optype = o;
                break;
            }
        }
    }

    public abstract Attribute getFieldAsAttribute();

    public static enum Optype {
        NONE("none"),
        CONTINUOUS("continuous"),
        CATEGORICAL("categorical"),
        ORDINAL("ordinal");

        private final String m_stringVal;

        private Optype(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    public static class Interval
    implements Serializable {
        private static final long serialVersionUID = -7339790632684638012L;
        protected double m_leftMargin = Double.NEGATIVE_INFINITY;
        protected double m_rightMargin = Double.POSITIVE_INFINITY;
        protected Closure m_closure = Closure.OPENOPEN;

        protected Interval(Element interval) throws Exception {
            String leftM = interval.getAttribute("leftMargin");
            try {
                this.m_leftMargin = Double.parseDouble(leftM);
            }
            catch (IllegalArgumentException ex) {
                throw new Exception("[Interval] Can't parse left margin as a number");
            }
            String rightM = interval.getAttribute("rightMargin");
            try {
                this.m_rightMargin = Double.parseDouble(rightM);
            }
            catch (IllegalArgumentException ex) {
                throw new Exception("[Interval] Can't parse right margin as a number");
            }
            String closure = interval.getAttribute("closure");
            if (closure == null || closure.length() == 0) {
                throw new Exception("[Interval] No closure specified!");
            }
            for (Closure c : Closure.values()) {
                if (!c.toString().equals(closure)) continue;
                this.m_closure = c;
                break;
            }
        }

        public boolean containsValue(double value) {
            boolean result = false;
            switch (this.m_closure) {
                case OPENCLOSED: {
                    if (!(value > this.m_leftMargin) || !(value <= this.m_rightMargin)) break;
                    result = true;
                    break;
                }
                case OPENOPEN: {
                    if (!(value > this.m_leftMargin) || !(value < this.m_rightMargin)) break;
                    result = true;
                    break;
                }
                case CLOSEDOPEN: {
                    if (!(value >= this.m_leftMargin) || !(value < this.m_rightMargin)) break;
                    result = true;
                    break;
                }
                case CLOSEDCLOSED: {
                    if (!(value >= this.m_leftMargin) || !(value <= this.m_rightMargin)) break;
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }

        public String toString() {
            return this.m_closure.toString(this.m_leftMargin, this.m_rightMargin);
        }

        public static enum Closure {
            OPENCLOSED("openClosed", "(", "]"),
            OPENOPEN("openOpen", "(", ")"),
            CLOSEDOPEN("closedOpen", "[", ")"),
            CLOSEDCLOSED("closedClosed", "[", "]");

            private final String m_stringVal;
            private final String m_left;
            private final String m_right;

            private Closure(String name, String left, String right) {
                this.m_stringVal = name;
                this.m_left = left;
                this.m_right = right;
            }

            public String toString() {
                return this.m_stringVal;
            }

            public String toString(double leftMargin, double rightMargin) {
                return this.m_left + leftMargin + "-" + rightMargin + this.m_right;
            }
        }
    }

    public static class Value
    implements Serializable {
        private static final long serialVersionUID = -3981030320273649739L;
        protected String m_value;
        protected String m_displayValue;
        protected Property m_property = Property.VALID;

        protected Value(Element value) throws Exception {
            String property;
            this.m_value = value.getAttribute("value");
            String displayV = value.getAttribute("displayValue");
            if (displayV != null && displayV.length() > 0) {
                this.m_displayValue = displayV;
            }
            if ((property = value.getAttribute("property")) != null && property.length() > 0) {
                for (Property p : Property.values()) {
                    if (!p.toString().equals(property)) continue;
                    this.m_property = p;
                    break;
                }
            }
        }

        public String toString() {
            String retV = this.m_value;
            if (this.m_displayValue != null) {
                retV = retV + "(" + this.m_displayValue + "): " + this.m_property.toString();
            }
            return retV;
        }

        public String getValue() {
            return this.m_value;
        }

        public String getDisplayValue() {
            return this.m_displayValue;
        }

        public Property getProperty() {
            return this.m_property;
        }

        public static enum Property {
            VALID("valid"),
            INVALID("invalid"),
            MISSING("missing");

            private final String m_stringVal;

            private Property(String name) {
                this.m_stringVal = name;
            }

            public String toString() {
                return this.m_stringVal;
            }
        }
    }
}

