*-------------------------------------------------------------------------*
|             SAS DATA DEFINITION STATEMENTS FOR ICPSR 8703               |
|                                                                         |
|         UNIFORM CRIME REPORTING PROGRAM DATA [UNITED STATES:            |
|           COUNTY LEVEL ARREST AND OFFENSES DATA, 1977-1983              |
|                                                                         |
|                         PARTS 1,3,5,7,9,11,13                           |
|                                                                         |
|                        FILE GENERATED: 08JUL98                          |
|                                                                         |
| This SAS setup file contains the following statements:                  |
|                                                                         |
| DATA:  Begins a SAS data step and names an output SAS data set.         |
|                                                                         |
| INFILE:  Specifies the input data file to be read with the input        |
| statement. Users must replace "file-specification" with a complete      |
| statement of the location of the data file.                             |
|                                                                         |
| INPUT:  Assigns the name, type, decimal specification (if any), and     |
| identifies variable beginning and ending column locations.              |
|                                                                         |
| LABEL:  Assigns descriptive labels to variables. Variable labels and    |
| variable names may be identical for certain variables.                  |
|                                                                         |
| MISSING VALUE RECODES:  Sets user-defined numeric missing values to     |
| missing as interpreted by the SAS system. Missing value recodes may not |
| be present for all variables in the data file.                          |
|                                                                         |
| NOTE:  Users should modify this SAS setup file to suit their specific   |
| needs. PROC FORMAT, FORMAT, and MISSING VALUE RECODES sections have     |
| been marked by SAS comment statements. To include these sections in a   |
| final SAS setup, users should remove the SAS comment statements from    |
| the desired section(s).                                                 |
*-------------------------------------------------------------------------;
*VARIABLE DESCRIPTION FOR UCR COUNTY ARREST FILES ;                        
*(Parts 1,3,5,7,9,11,13) ;                                                 
                                                                           
data;                                                                      
infile "da8703f13" lrecl=83;                                               
                                                                           
input                                                                      
  v1 1-4                                                                   
  v2 5                                                                     
  v3 6-7                                                                   
  v4 8-11                                                                  
  v5 12-13                                                                 
  v6 14-16                                                                 
  v7   17-23                                                               
  v8 24-30                                                                 
  v9 31-36                                                                 
  v10 37-41                                                                
  v11 42-46                                                                
  v12 47-50                                                                
  v13 51-54                                                                
  v14 55-59                                                                
  v15 60-64                                                                
  v16 65-69                                                                
  v17 70-74                                                                
  v18 75-79                                                                
  v19 80-83;                                                               
                                                                           
* SAS LABEL STATEMENT;                                                     
                                                                           
LABEL                                                                      
   V1 = "ICPSR STUDY NUMBER"                                               
   V2 = "ICPSR EDITION NUMBER"                                             
   V3 = "ICPSR PART NUMBER"                                                
   V4 = "ICPSR SEQUENCE NUMBER"                                            
   V5 = "STATE CODE"                                                       
   V6 = "COUNTY CODE"                                                      
   V7 = "POPULATION"                                                       
   V8 = "GRAND TOTAL"                                                      
   V9 = "PART 1 TOTAL"                                                     
   V10 = "VIOLENT CRIMES"                                                  
   V11 = "PROPERTY CRIMES"                                                 
   V12 = "MURDER"                                                          
   V13 = "RAPE"                                                            
   V14 = "ROBBERY"                                                         
   V15 = "ASSAULT"                                                         
   V16 = "BURGLARY"                                                        
   V17 = "LARCENY"                                                         
   V18 = "VEHICLE THEFT"                                                   
   V19 = "ARSON";                                                          
                                                                           
* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;                         
                                                                           
   IF V7=9999999 THEN V7=.;            IF V8=9999999 THEN V8=.;            
   IF V9=999999 THEN V9=.;             IF V10=99999 THEN V10=.;            
   IF V11=99999 THEN V11=.;            IF V12=9999 THEN V12=.;             
   IF V13=9999 THEN V13=.;             IF V14=99999 THEN V14=.;            
   IF V15=99999 THEN V15=.;            IF V16=99999 THEN V16=.;            
   IF V17=99999 THEN V17=.;            IF V18=99999 THEN V18=.;            
   IF V19=9999 THEN V19=.;                                                 
