# Licensing Information for `crimedatasets` Package

This package, `crimedatasets`, includes datasets sourced from various R packages. In order to maintain consistency and clarity, a naming convention has been applied where suffixes are added to the dataset names to indicate the type and format of the datasets. The original content of these datasets has not been altered in any way.

## Dataset Licensing Information:

- **homicides15_tbl_df**: 
  Originally homicides15 from the crimedata package, licensed under MIT + file LICENSE. The dataset name has been changed to 'homicides15_tbl_df' to indicate that this dataset is a tibble object.

- **vehiclethefts_tbl_df**: 
  Originally nycvehiclethefts from the crimedata package, licensed under MIT + file LICENSE. The dataset name has been changed to 'vehiclethefts_tbl_df' to indicate that this dataset is a tibble object.
   
- **USArrests_df**: 
  Originally USArrests from the datasets package, licensed under GPL-2 or GPL-3. The dataset name has been changed to 'USArrests_df' to indicate that this dataset is a data frame object.
   
  
- **USJudgeRatings_df**: 
  Originally USJudgeRatings from the datasets package, licensed under GPL-2 or GPL-3. The dataset name has been changed to 'USJudgeRatings_df' to indicate that this dataset is a data frame object.
  
- **crimtab_table**: 
  Originally crimtab from the datasets package, licensed under GPL-2 or GPL-3. The dataset name has been changed to 'crimtab_table' to indicate that this dataset is a table object.   

- **Boston_df**: 
  Originally Boston from the MASS package, licensed under GPL-2 or GPL-3. The dataset name has been changed to 'Boston_df' to indicate that this dataset is a data frame object.    


- **UScrime_df**: 
  Originally UScrime from the MASS package, licensed under GPL-2 or GPL-3. The dataset name has been changed to 'UScrime_df' to indicate that this dataset is a data frame object.   

- **communities_crime_df**: 
  Originally communities.and.crime from the fairml package, licensed under MIT + file LICENSE. The dataset name has been changed to 'communities_crime_df' to indicate that this dataset is a data frame object.   

- **crimOffenders_df**: 
  Originally compas from the fairml package, licensed under MIT + file LICENSE. The dataset name has been changed to 'crimOffenders_df' to indicate that this dataset is a data frame object.   

- **birmingham_crime_sf**: 
  Originally birmingham_crime from the rts2 package, licensed under CC BY-SA 4.0. The dataset name has been changed to 'birmingham_crime_sf' to indicate that this dataset is a sf object.   


- **NCAdata_tbl_df**: 
  Originally NCAdata from the aihuman package, licensed under GPL (>= 2). The dataset name has been changed to 'NCAdata_tbl_df' to indicate that this dataset is a data frame object.     

- **NVCAdata_tbl_df**: 
  Originally NVCAdata from the aihuman package, licensed under GPL (>= 2). The dataset name has been changed to 'NVCAdata_tbl_df' to indicate that this dataset is a data frame object.   

- **Hartnagel_df**: 
  Originally Hartnagel from the carData package, licensed under GPL (>= 2). The dataset name has been changed to 'Hartnagel_df' to indicate that this dataset is a data frame object.   

- **Rossi_df**: 
  Originally Rossi from the carData package, licensed under GPL (>= 2). The dataset name has been changed to 'Rossi_df' to indicate that this dataset is a data frame object.   

- **georgia_sf**: 
  Originally georgia from the geostan package, licensed under GPL (>= 3). The dataset name has been changed to 'georgia_sf' to indicate that this dataset is a sf object.   

- **sentencing_sf**: 
  Originally sentencing from the geostan package, licensed under GPL (>= 3). The dataset name has been changed to 'sentencing_sf' to indicate that this dataset is a sf object.   


- **Ndrangheta_list**: 
  Originally Ndrangheta from the greed package, licensed under GPL. The dataset name has been changed to 'Ndrangheta_list' to indicate that this dataset is a list object.  


- **crimestatewide_tbl_df**: 
  Originally crime from the GUD package, licensed under GPL (>= 3). The dataset name has been changed to 'crimestatewide_tbl_df' to indicate that this dataset is a tibble object.   

- **police_shootings_tbl_df**: 
  Originally fatal_police_shootings from the usdata package, licensed under GPL-3. The dataset name has been changed to 'police_shootings_tbl_df' to indicate that this dataset is a tibble object.     

- **UScrimerates_tbl_df**: 
  Originally us_crime_rates from the usdata package, licensed under GPL-3. The dataset name has been changed to 'UScrimerates_tbl_df' to indicate that this dataset is a tibble object.


- **camden_crimes_df**: 
  Originally camden_crimes from the stppSim package, licensed under GPL-3. The dataset name has been changed to 'camden_crimes_df' to indicate that this dataset is a data frame object.  

- **nz_murders_sf**: 
  Originally nz_murders from the stelfi package, licensed under GPL (>= 3). The dataset name has been changed to 'nz_murders_sf' to indicate that this dataset is a sf object.  


- **uk_serial_df**: 
  Originally uk_serial from the stelfi package, licensed under GPL (>= 3). The dataset name has been changed to 'uk_serial_df' to indicate that this dataset is a data frame object.  

- **wmurders_ts**: 
  Originally wmurders from the fpp package, licensed under GPL (>= 2). The dataset name has been changed to 'wmurders_ts' to indicate that this dataset is a time series object.  

- **hate_crimes_tbl_df**: 
  Originally hate_crimes from the fivethirtyeight package, licensed under MIT + file LICENSE. The dataset name has been changed to 'hate_crimes_tbl_df' to indicate that this dataset is a tibble object.  

- **rearrests_table**: 
  Originally rearrests from the HSAUR2 package, licensed under GPL-2. The dataset name has been changed to 'rearrests_table' to indicate that this dataset is a table object.   

- **Fatality_df**: 
  Originally Fatality from the Ecdat package, licensed under GPL (>= 2). The dataset name has been changed to 'Fatality_df' to indicate that this dataset is a data frame object.   

- **CyberSecurityBreaches_df**: 
  Originally HHSCyberSecurityBreaches from the Ecdat package, licensed under GPL (>= 2). The dataset name has been changed to 'CyberSecurityBreaches_df' to indicate that this dataset is a data frame object.   

- **USincarcerations_df**: 
  Originally USincarcerations from the Ecdat package, licensed under GPL (>= 2). The dataset name has been changed to 'USincarcerations_df' to indicate that this dataset is a data frame object.   

- **TerrorismGlobal_table**: 
  Originally incidents.byCountryYr from the Ecdat package, licensed under GPL (>= 2). The dataset name has been changed to 'TerrorismGlobal_table' to indicate that this dataset is a table object.   

- **DrunkDST_tbl_df**: 
  Originally DST from the stevedata package, licensed under GPL-2. The dataset name has been changed to 'DrunkDST_tbl_df' to indicate that this dataset is a tibble object.  

- **pinochet_df**: 
  Originally pinochet from the pinochet package, licensed under MIT + file LICENSE. The dataset name has been changed to 'pinochet_df' to indicate that this dataset is a data frame object.   

- **Abilene_tbl_df**: 
  Originally Abilene from the BSDA package, licensed under GPL-3. The dataset name has been changed to 'Abilene_tbl_df' to indicate that this dataset is a data frame object.  

- **Attorney_tbl_df**: 
  Originally Attorney from the BSDA package, licensed under GPL-3. The dataset name has been changed to 'Attorney_tbl_df' to indicate that this dataset is a data frame object. 


- **crimeHSdegree_tbl_df**: 
  Originally Educat from the BSDA package, licensed under GPL-3. The dataset name has been changed to 'crimeHSdegree_tbl_df' to indicate that this dataset is a tibble object.   

- **Gallup_tbl_df**: 
  Originally Gallup from the BSDA package, licensed under GPL-3. The dataset name has been changed to 'Gallup_tbl_df' to indicate that this dataset is a tibble object.   

- **Inmate_tbl_df**: 
  Originally Inmate from the BSDA package, licensed under GPL-3. The dataset name has been changed to 'Inmate_tbl_df' to indicate that this dataset is a tibble object.   

- **Sentence_tbl_df**: 
  Originally Sentence from the BSDA package, licensed under GPL-3. The dataset name has been changed to 'Sentence_tbl_df' to indicate that this dataset is a tibble object.    


- **UCR2015_df**: 
  Originally UCR2015 from the vannstats package, licensed under GPL-3. The dataset name has been changed to 'UCR2015_df' to indicate that this dataset is a data frame object.   

- **corruption_tbl_df**: 
  Originally corruption from the regioncode package, licensed under MIT + file LICENSE. The dataset name has been changed to 'corruption_tbl_df' to indicate that this dataset is a tibble object.   

- **Suicide_Germany_df**: 
  Originally Suicide from the vcd package, licensed under GPL-2. The dataset name has been changed to 'Suicide_Germany_df' to indicate that this dataset is a data frame object. 

- **DeathPenaltyRace_df**: 
  Originally case1902 from the Sleuth3 package, licensed under GPL (>= 2). The dataset name has been changed to 'DeathPenaltyRace_df' to indicate that this dataset is a data frame object.    


- **USATerror_data_df**: 
  Originally Terror_data_USA from the fitODBOD package, licensed under MIT + file LICENSE. The dataset name has been changed to 'USATerror_data_df' to indicate that this dataset is a data frame object. 

- **NigeriaTerrorism_df**: 
  Originally terror from the bizicount package, licensed under GPL (>= 3). The dataset name has been changed to 'NigeriaTerrorism_df' to indicate that this dataset is a data frame object.   

- **fraudulent_df**: 
  Originally fraudulent from the cond package, licensed under GPL (>= 2) | file LICENCE. The dataset name has been changed to 'fraudulent_df' to indicate that this dataset is a data frame object.   

- **CrimesUSA1990_X_df**: 
  Originally CrimesUSA1990.X from the nda, licensed under GPL (>= 2). The dataset name has been changed to 'CrimesUSA1990_X_df' to indicate that this dataset is a data frame object.   

- **CrimesUSA1990_Y_df**: 
  Originally CrimesUSA1990.Y from the nda, licensed under GPL (>= 2). The dataset name has been changed to 'CrimesUSA1990_Y_df' to indicate that this dataset is a data frame object.   


- **FBICriminal_tbl_df**: 
  Originally alldata from the gunsales package, licensed under Apache License (== 2). The dataset name has been changed to 'FBICriminal_tbl_df' to indicate that this dataset is a tibble object.   



 
## License

All datasets in this package are provided under the same licenses as their original sources. The licensing information and any specific attribution required for each dataset can be found within their respective packages. The user must adhere to the licensing terms specified by each original source.

This package, `crimedatasets`, is licensed under the GPL-3 License.
 
