/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.BIOTokenizationFilter;
import cc.mallet.extract.DocumentExtraction;
import cc.mallet.extract.Extraction;
import cc.mallet.extract.Extractor;
import cc.mallet.extract.Tokenization;
import cc.mallet.extract.TokenizationFilter;
import cc.mallet.fst.CRF;
import cc.mallet.pipe.Noop;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.Sequence;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class CRFExtractor
implements Extractor {
    private CRF crf;
    private Pipe tokenizationPipe;
    private Pipe featurePipe;
    private String backgroundTag;
    private TokenizationFilter filter;
    private static final int CURRENT_SERIAL_VERSION = 2;
    private static final long serialVersionUID = 1L;

    public CRFExtractor(CRF crf) {
        this(crf, new Noop());
    }

    public CRFExtractor(File crfFile) throws IOException {
        this(CRFExtractor.loadCrf(crfFile), new Noop());
    }

    public CRFExtractor(CRF crf, Pipe tokpipe) {
        this(crf, tokpipe, new BIOTokenizationFilter());
    }

    public CRFExtractor(CRF crf, Pipe tokpipe, TokenizationFilter filter) {
        this(crf, tokpipe, filter, "O");
    }

    public CRFExtractor(CRF crf, Pipe tokpipe, TokenizationFilter filter, String backgroundTag) {
        this.crf = crf;
        this.tokenizationPipe = tokpipe;
        this.featurePipe = crf.getInputPipe();
        this.filter = filter;
        this.backgroundTag = backgroundTag;
    }

    private static CRF loadCrf(File crfFile) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(crfFile));
        CRF crf = null;
        try {
            crf = (CRF)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            System.err.println("Internal MALLET error: Could not read CRF from file " + crfFile + "\n" + e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        ois.close();
        return crf;
    }

    @Override
    public Extraction extract(Object o) {
        if (o instanceof Tokenization) {
            return this.extract((Tokenization)o);
        }
        if (o instanceof InstanceList) {
            return this.extract((InstanceList)o);
        }
        return this.extract(this.doTokenize(o));
    }

    private Tokenization doTokenize(Object obj) {
        Instance toked = new Instance(obj, null, null, null);
        this.tokenizationPipe.pipe(toked);
        return (Tokenization)toked.getData();
    }

    @Override
    public Extraction extract(Tokenization spans) {
        Instance carrier = this.featurePipe.pipe(new Instance(spans, null, null, null));
        Sequence output = this.crf.transduce((Sequence)carrier.getData());
        Extraction extraction = new Extraction(this, this.getTargetAlphabet());
        DocumentExtraction docseq = new DocumentExtraction("Extraction", this.getTargetAlphabet(), spans, output, null, this.backgroundTag, this.filter);
        extraction.addDocumentExtraction(docseq);
        return extraction;
    }

    public InstanceList pipeInstances(Iterator<Instance> source) {
        InstanceList toked = new InstanceList(this.tokenizationPipe);
        toked.addThruPipe(source);
        InstanceList piped = new InstanceList(this.getFeaturePipe());
        piped.addThruPipe(toked.iterator());
        return piped;
    }

    public Extraction extract(InstanceList ilist) {
        Extraction extraction = new Extraction(this, this.getTargetAlphabet());
        for (int i = 0; i < ilist.size(); ++i) {
            Instance inst = (Instance)ilist.get(i);
            Tokenization tok = (Tokenization)inst.getSource();
            String name = inst.getName().toString();
            Sequence input = (Sequence)inst.getData();
            Sequence target = (Sequence)inst.getTarget();
            Sequence output = this.crf.transduce(input);
            DocumentExtraction docseq = new DocumentExtraction(name, this.getTargetAlphabet(), tok, output, target, this.backgroundTag, this.filter);
            extraction.addDocumentExtraction(docseq);
        }
        return extraction;
    }

    @Override
    public Extraction extract(Iterator<Instance> source) {
        Extraction extraction = new Extraction(this, this.getTargetAlphabet());
        InstanceList tokedList = new InstanceList(this.tokenizationPipe);
        tokedList.addThruPipe(source);
        InstanceList pipedList = new InstanceList(this.getFeaturePipe());
        pipedList.addThruPipe(tokedList.iterator());
        Iterator it1 = tokedList.iterator();
        Iterator it2 = pipedList.iterator();
        while (it1.hasNext()) {
            Instance toked = (Instance)it1.next();
            Instance piped = (Instance)it2.next();
            Tokenization tok = (Tokenization)toked.getData();
            String name = piped.getName().toString();
            Sequence input = (Sequence)piped.getData();
            Sequence target = (Sequence)piped.getTarget();
            Sequence output = this.crf.transduce(input);
            DocumentExtraction docseq = new DocumentExtraction(name, this.getTargetAlphabet(), tok, output, target, this.backgroundTag, this.filter);
            extraction.addDocumentExtraction(docseq);
        }
        return extraction;
    }

    public TokenizationFilter getTokenizationFilter() {
        return this.filter;
    }

    public String getBackgroundTag() {
        return this.backgroundTag;
    }

    @Override
    public Pipe getTokenizationPipe() {
        return this.tokenizationPipe;
    }

    @Override
    public void setTokenizationPipe(Pipe tokenizationPipe) {
        this.tokenizationPipe = tokenizationPipe;
    }

    @Override
    public Pipe getFeaturePipe() {
        return this.featurePipe;
    }

    public void setFeaturePipe(Pipe featurePipe) {
        this.featurePipe = featurePipe;
    }

    @Override
    public Alphabet getInputAlphabet() {
        return this.crf.getInputAlphabet();
    }

    @Override
    public LabelAlphabet getTargetAlphabet() {
        return (LabelAlphabet)this.crf.getOutputAlphabet();
    }

    public CRF getCrf() {
        return this.crf;
    }

    public void slicePipes(int num) {
        Pipe fpipe = this.getFeaturePipe();
        if (!(fpipe instanceof SerialPipes)) {
            throw new IllegalArgumentException("slicePipes: FeaturePipe must be a SerialPipes.");
        }
        SerialPipes sp = (SerialPipes)fpipe;
        ArrayList<Pipe> pipes = new ArrayList<Pipe>();
        for (int i = 0; i < num; ++i) {
            pipes.add(sp.getPipe(0));
        }
        throw new UnsupportedOperationException("Not yet implemented...");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
        if (version == 0 || this.featurePipe == null) {
            this.featurePipe = this.crf.getInputPipe();
        }
        if (version < 2) {
            this.filter = new BIOTokenizationFilter();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(2);
    }

    public Sequence pipeInput(Object input) {
        InstanceList all = new InstanceList(this.getFeaturePipe());
        all.add(input, null, null, null);
        return (Sequence)((Instance)all.get(0)).getData();
    }
}

