/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.global.automata.fast_multicostregular.algo;

import choco.kernel.common.Constant;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.global.automata.common.StoredIndexedBipartiteSetWithOffset;
import choco.kernel.solver.constraints.global.automata.fast_multicostregular.structure.SoftStoredMultiValuedDirectedMultiGraph;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntStack;
import java.util.Arrays;

public class SoftPathFinder {
    SoftStoredMultiValuedDirectedMultiGraph graph;
    int[] sp;
    int[] lp;
    int nbLayer;
    int nbR;
    public double[][] spfs;
    public double[][] spft;
    double[][] lpfs;
    double[][] lpft;
    boolean[] modified = new boolean[2];
    int[][] prevSP;
    int[][] nextSP;
    int[][] prevLP;
    int[][] nextLP;

    public SoftPathFinder(SoftStoredMultiValuedDirectedMultiGraph graph) {
        this.graph = graph;
        this.sp = new int[graph.layers.length - 1];
        this.lp = new int[graph.layers.length - 1];
        this.nbLayer = graph.layers.length - 1;
        this.nbR = this.graph.nbR;
        this.spfs = this.graph.GNodes.spfsI;
        this.spft = this.graph.GNodes.spftI;
        this.lpfs = this.graph.GNodes.lpfsI;
        this.lpft = this.graph.GNodes.lpftI;
        this.prevSP = this.graph.GNodes.prevSPI;
        this.nextSP = this.graph.GNodes.nextSPI;
        this.prevLP = this.graph.GNodes.prevLPI;
        this.nextLP = this.graph.GNodes.nextLPI;
    }

    private final double getCost(int e, double[] u) {
        double cost = 0.0;
        for (int r = 0; r < u.length; ++r) {
            cost += this.graph.GArcs.originalCost[e][r] * u[r];
        }
        this.graph.GArcs.temporaryCost[e] = cost;
        return cost;
    }

    public void computeLongestPath(TIntStack removed, double lb, double[] u) throws ContradictionException {
        double newCost;
        int e;
        int x;
        StoredIndexedBipartiteSetWithOffset bs;
        int w;
        int size;
        int[] list;
        boolean update;
        int i;
        this.graph.GNodes.lpfs[this.graph.sourceIndex] = 0.0;
        this.graph.GNodes.lpft[this.graph.tinIndex] = 0.0;
        for (i = 1; i <= this.nbLayer; ++i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int dest = list[w];
                bs = this.graph.GNodes.inArcs[dest];
                assert (!bs.isEmpty());
                int[] inlist = bs._getStructure();
                int insize = bs.size();
                this.graph.GNodes.lpfs[dest] = Double.NEGATIVE_INFINITY;
                for (x = 0; x < insize; ++x) {
                    int orig;
                    e = inlist[x];
                    if (this.graph.isInStack(e) || !(this.graph.GNodes.lpfs[dest] < (newCost = this.graph.GNodes.lpfs[orig = this.graph.GArcs.origs[e]] + this.getCost(e, u)))) continue;
                    this.graph.GNodes.lpfs[dest] = newCost;
                    this.graph.GNodes.prevLP[dest] = e;
                    update = true;
                }
            }
            if (update) continue;
            this.graph.constraint.fail();
        }
        for (i = this.nbLayer - 1; i >= 0; --i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int orig = list[w];
                bs = this.graph.GNodes.outArcs[orig];
                assert (!bs.isEmpty());
                int[] outlist = bs._getStructure();
                int outsize = bs.size();
                this.graph.GNodes.lpft[orig] = Double.NEGATIVE_INFINITY;
                for (x = 0; x < outsize; ++x) {
                    e = outlist[x];
                    if (this.graph.isInStack(e)) continue;
                    int next = this.graph.GArcs.dests[e];
                    newCost = this.graph.GNodes.lpft[next] + this.graph.GArcs.temporaryCost[e];
                    if (newCost + this.graph.GNodes.lpfs[orig] - lb <= -Constant.MCR_DECIMAL_PREC) {
                        this.graph.setInStack(e);
                        removed.push(e);
                        continue;
                    }
                    if (!(this.graph.GNodes.lpft[orig] < newCost)) continue;
                    this.graph.GNodes.lpft[orig] = newCost;
                    this.graph.GNodes.nextLP[orig] = e;
                    update = true;
                }
            }
            if (update) continue;
            this.graph.constraint.fail();
        }
    }

    public final double getLongestPathValue() {
        return this.graph.GNodes.lpft[this.graph.sourceIndex];
    }

    public int[] getLongestPath() {
        int e;
        int i = 0;
        int current = this.graph.sourceIndex;
        do {
            e = this.graph.GNodes.nextLP[current];
            this.sp[i++] = e;
        } while (this.graph.GNodes.nextLP[current = this.graph.GArcs.dests[e]] != Integer.MIN_VALUE);
        return this.sp;
    }

    public void computeShortestPath(TIntStack removed, double ub, double[] u) throws ContradictionException {
        double newCost;
        int e;
        int x;
        StoredIndexedBipartiteSetWithOffset bs;
        int w;
        int size;
        int[] list;
        boolean update;
        int i;
        this.graph.GNodes.spfs[this.graph.sourceIndex] = 0.0;
        this.graph.GNodes.spft[this.graph.tinIndex] = 0.0;
        for (i = 1; i <= this.nbLayer; ++i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int dest = list[w];
                this.graph.GNodes.spfs[dest] = Double.POSITIVE_INFINITY;
                bs = this.graph.GNodes.inArcs[dest];
                assert (!bs.isEmpty());
                int[] inlist = bs._getStructure();
                int insize = bs.size();
                for (x = 0; x < insize; ++x) {
                    int orig;
                    e = inlist[x];
                    if (this.graph.isInStack(e) || !(this.graph.GNodes.spfs[dest] > (newCost = this.graph.GNodes.spfs[orig = this.graph.GArcs.origs[e]] + this.getCost(e, u)))) continue;
                    this.graph.GNodes.spfs[dest] = newCost;
                    this.graph.GNodes.prevSP[dest] = e;
                    update = true;
                }
            }
            if (update) continue;
            this.graph.constraint.fail();
        }
        for (i = this.nbLayer - 1; i >= 0; --i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int orig = list[w];
                this.graph.GNodes.spft[orig] = Double.POSITIVE_INFINITY;
                bs = this.graph.GNodes.outArcs[orig];
                assert (!bs.isEmpty());
                int[] outlist = bs._getStructure();
                int outsize = bs.size();
                for (x = 0; x < outsize; ++x) {
                    e = outlist[x];
                    if (this.graph.isInStack(e)) continue;
                    int dest = this.graph.GArcs.dests[e];
                    newCost = this.graph.GNodes.spft[dest] + this.graph.GArcs.temporaryCost[e];
                    if (newCost + this.graph.GNodes.spfs[orig] - ub >= Constant.MCR_DECIMAL_PREC) {
                        this.graph.setInStack(e);
                        removed.push(e);
                        continue;
                    }
                    if (!(this.graph.GNodes.spft[orig] > newCost)) continue;
                    this.graph.GNodes.spft[orig] = newCost;
                    this.graph.GNodes.nextSP[orig] = e;
                    update = true;
                }
            }
            if (update) continue;
            this.graph.constraint.fail();
        }
    }

    public final double getShortestPathValue() {
        return this.graph.GNodes.spft[this.graph.sourceIndex];
    }

    public int[] getShortestPath() {
        int e;
        int i = 0;
        int current = this.graph.sourceIndex;
        do {
            e = this.graph.GNodes.nextSP[current];
            this.sp[i++] = e;
        } while (this.graph.GNodes.nextSP[current = this.graph.GArcs.dests[e]] != Integer.MIN_VALUE);
        return this.sp;
    }

    public boolean[] computeShortestAndLongestPath(TIntStack removed, IntDomainVar[] y, AbstractIntSConstraint[] tables) throws ContradictionException {
        int d;
        double[] cost;
        int e;
        int x;
        StoredIndexedBipartiteSetWithOffset bs;
        int w;
        int size;
        int[] list;
        boolean update;
        int i;
        int nbr = y.length;
        for (int i2 = 0; i2 < nbr; ++i2) {
            this.spfs[this.graph.sourceIndex][i2] = 0.0;
            this.spft[this.graph.tinIndex][i2] = 0.0;
            this.lpfs[this.graph.sourceIndex][i2] = 0.0;
            this.lpft[this.graph.tinIndex][i2] = 0.0;
        }
        for (i = 1; i <= this.nbLayer; ++i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int dest = list[w];
                Arrays.fill(this.spfs[dest], Double.POSITIVE_INFINITY);
                Arrays.fill(this.lpfs[dest], Double.NEGATIVE_INFINITY);
                bs = this.graph.GNodes.inArcs[dest];
                assert (!bs.isEmpty());
                int[] inlist = bs._getStructure();
                int insize = bs.size();
                for (x = 0; x < insize; ++x) {
                    e = inlist[x];
                    if (this.graph.isInStack(e)) continue;
                    int orig = this.graph.GArcs.origs[e];
                    cost = this.graph.GArcs.originalCost[e];
                    for (d = 0; d < nbr; ++d) {
                        if (this.spfs[dest][d] > cost[d] + this.spfs[orig][d]) {
                            this.spfs[dest][d] = cost[d] + this.spfs[orig][d];
                            this.prevSP[dest][d] = e;
                            update = true;
                        }
                        if (!(this.lpfs[dest][d] < this.lpfs[orig][d] + cost[d])) continue;
                        this.lpfs[dest][d] = this.lpfs[orig][d] + cost[d];
                        this.prevLP[dest][d] = e;
                        update = true;
                    }
                }
            }
            if (update) continue;
            this.graph.constraint.fail();
        }
        for (i = this.nbLayer - 1; i >= 0; --i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int orig = list[w];
                Arrays.fill(this.spft[orig], Double.POSITIVE_INFINITY);
                Arrays.fill(this.lpft[orig], Double.NEGATIVE_INFINITY);
                bs = this.graph.GNodes.outArcs[orig];
                assert (!bs.isEmpty());
                int[] outlist = bs._getStructure();
                int outsize = bs.size();
                block7: for (x = 0; x < outsize; ++x) {
                    e = outlist[x];
                    if (this.graph.isInStack(e)) continue;
                    int dest = this.graph.GArcs.dests[e];
                    cost = this.graph.GArcs.originalCost[e];
                    for (d = 0; d < nbr; ++d) {
                        if (this.spft[dest][d] + cost[d] + this.spfs[orig][d] - (double)y[d].getSup() >= Constant.MCR_DECIMAL_PREC) {
                            this.graph.getInStack().set(e);
                            removed.push(e);
                            continue block7;
                        }
                        if (this.spft[orig][d] > this.spft[dest][d] + cost[d]) {
                            this.spft[orig][d] = this.spft[dest][d] + cost[d];
                            this.nextSP[orig][d] = e;
                            update = true;
                        }
                        if (this.lpft[dest][d] + cost[d] + this.lpfs[orig][d] - (double)y[d].getInf() <= -Constant.MCR_DECIMAL_PREC) {
                            this.graph.setInStack(e);
                            removed.push(e);
                            continue block7;
                        }
                        if (!(this.lpft[orig][d] < this.lpft[dest][d] + cost[d])) continue;
                        this.lpft[orig][d] = this.lpft[dest][d] + cost[d];
                        this.nextLP[orig][d] = e;
                        update = true;
                    }
                }
            }
            if (update) continue;
            this.graph.constraint.fail();
        }
        for (i = 0; i < nbr; ++i) {
            if (y[i].updateInf((int)Math.ceil(this.spft[this.graph.sourceIndex][i]), this.graph.constraint, false)) {
                tables[i].awakeOnInf(0);
            }
            if (!y[i].updateSup((int)Math.floor(this.lpft[this.graph.sourceIndex][i]), this.graph.constraint, false)) continue;
            tables[i].awakeOnSup(0);
        }
        return this.modified;
    }
}

